/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Geometry;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class Point
implements Geometry {
    private String type;
    private List<Double> coordinates;

    public Point() {
    }

    public Point(String type, List<Double> coordinates) {
        this.type = type;
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public List<Double> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Double> coordinates) {
        this.coordinates = coordinates;
    }

    public String toString() {
        return "Point{type='" + this.type + "', coordinates='" + this.coordinates + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point that = (Point)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.coordinates);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private List<Double> coordinates;

        public Point build() {
            Point result = new Point();
            result.type = this.type;
            result.coordinates = this.coordinates;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder coordinates(List<Double> coordinates) {
            this.coordinates = coordinates;
            return this;
        }
    }
}

