/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Product;
import com.commercetools.graphql.api.types.ProductSelection;
import com.commercetools.graphql.api.types.ProductVariantExclusion;
import com.commercetools.graphql.api.types.ProductVariantSelection;
import com.commercetools.graphql.api.types.Reference;
import java.util.Objects;

public class ProductAssignment {
    private Reference productRef;
    private Product product;
    private Reference productSelectionRef;
    private ProductSelection productSelection;
    private ProductVariantSelection variantSelection;
    private ProductVariantExclusion variantExclusion;

    public ProductAssignment() {
    }

    public ProductAssignment(Reference productRef, Product product, Reference productSelectionRef, ProductSelection productSelection, ProductVariantSelection variantSelection, ProductVariantExclusion variantExclusion) {
        this.productRef = productRef;
        this.product = product;
        this.productSelectionRef = productSelectionRef;
        this.productSelection = productSelection;
        this.variantSelection = variantSelection;
        this.variantExclusion = variantExclusion;
    }

    public Reference getProductRef() {
        return this.productRef;
    }

    public void setProductRef(Reference productRef) {
        this.productRef = productRef;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Reference getProductSelectionRef() {
        return this.productSelectionRef;
    }

    public void setProductSelectionRef(Reference productSelectionRef) {
        this.productSelectionRef = productSelectionRef;
    }

    public ProductSelection getProductSelection() {
        return this.productSelection;
    }

    public void setProductSelection(ProductSelection productSelection) {
        this.productSelection = productSelection;
    }

    public ProductVariantSelection getVariantSelection() {
        return this.variantSelection;
    }

    public void setVariantSelection(ProductVariantSelection variantSelection) {
        this.variantSelection = variantSelection;
    }

    public ProductVariantExclusion getVariantExclusion() {
        return this.variantExclusion;
    }

    public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
        this.variantExclusion = variantExclusion;
    }

    public String toString() {
        return "ProductAssignment{productRef='" + this.productRef + "', product='" + this.product + "', productSelectionRef='" + this.productSelectionRef + "', productSelection='" + this.productSelection + "', variantSelection='" + this.variantSelection + "', variantExclusion='" + this.variantExclusion + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductAssignment that = (ProductAssignment)o;
        return Objects.equals(this.productRef, that.productRef) && Objects.equals(this.product, that.product) && Objects.equals(this.productSelectionRef, that.productSelectionRef) && Objects.equals(this.productSelection, that.productSelection) && Objects.equals(this.variantSelection, that.variantSelection) && Objects.equals(this.variantExclusion, that.variantExclusion);
    }

    public int hashCode() {
        return Objects.hash(this.productRef, this.product, this.productSelectionRef, this.productSelection, this.variantSelection, this.variantExclusion);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Reference productRef;
        private Product product;
        private Reference productSelectionRef;
        private ProductSelection productSelection;
        private ProductVariantSelection variantSelection;
        private ProductVariantExclusion variantExclusion;

        public ProductAssignment build() {
            ProductAssignment result = new ProductAssignment();
            result.productRef = this.productRef;
            result.product = this.product;
            result.productSelectionRef = this.productSelectionRef;
            result.productSelection = this.productSelection;
            result.variantSelection = this.variantSelection;
            result.variantExclusion = this.variantExclusion;
            return result;
        }

        public Builder productRef(Reference productRef) {
            this.productRef = productRef;
            return this;
        }

        public Builder product(Product product) {
            this.product = product;
            return this;
        }

        public Builder productSelectionRef(Reference productSelectionRef) {
            this.productSelectionRef = productSelectionRef;
            return this;
        }

        public Builder productSelection(ProductSelection productSelection) {
            this.productSelection = productSelection;
            return this;
        }

        public Builder variantSelection(ProductVariantSelection variantSelection) {
            this.variantSelection = variantSelection;
            return this;
        }

        public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
            this.variantExclusion = variantExclusion;
            return this;
        }
    }
}

