/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.ProductPrice;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ProductPriceChanged
implements MessagePayload {
    private Integer variantId;
    private ProductPrice oldPrice;
    private ProductPrice newPrice;
    private Boolean staged;
    private ProductPrice oldStagedPrice;
    private String type;

    public ProductPriceChanged() {
    }

    public ProductPriceChanged(Integer variantId, ProductPrice oldPrice, ProductPrice newPrice, Boolean staged, ProductPrice oldStagedPrice, String type) {
        this.variantId = variantId;
        this.oldPrice = oldPrice;
        this.newPrice = newPrice;
        this.staged = staged;
        this.oldStagedPrice = oldStagedPrice;
        this.type = type;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public ProductPrice getOldPrice() {
        return this.oldPrice;
    }

    public void setOldPrice(ProductPrice oldPrice) {
        this.oldPrice = oldPrice;
    }

    public ProductPrice getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(ProductPrice newPrice) {
        this.newPrice = newPrice;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    public ProductPrice getOldStagedPrice() {
        return this.oldStagedPrice;
    }

    public void setOldStagedPrice(ProductPrice oldStagedPrice) {
        this.oldStagedPrice = oldStagedPrice;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ProductPriceChanged{variantId='" + this.variantId + "', oldPrice='" + this.oldPrice + "', newPrice='" + this.newPrice + "', staged='" + this.staged + "', oldStagedPrice='" + this.oldStagedPrice + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductPriceChanged that = (ProductPriceChanged)o;
        return Objects.equals(this.variantId, that.variantId) && Objects.equals(this.oldPrice, that.oldPrice) && Objects.equals(this.newPrice, that.newPrice) && Objects.equals(this.staged, that.staged) && Objects.equals(this.oldStagedPrice, that.oldStagedPrice) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.oldPrice, this.newPrice, this.staged, this.oldStagedPrice, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer variantId;
        private ProductPrice oldPrice;
        private ProductPrice newPrice;
        private Boolean staged;
        private ProductPrice oldStagedPrice;
        private String type;

        public ProductPriceChanged build() {
            ProductPriceChanged result = new ProductPriceChanged();
            result.variantId = this.variantId;
            result.oldPrice = this.oldPrice;
            result.newPrice = this.newPrice;
            result.staged = this.staged;
            result.oldStagedPrice = this.oldStagedPrice;
            result.type = this.type;
            return result;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder oldPrice(ProductPrice oldPrice) {
            this.oldPrice = oldPrice;
            return this;
        }

        public Builder newPrice(ProductPrice newPrice) {
            this.newPrice = newPrice;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }

        public Builder oldStagedPrice(ProductPrice oldStagedPrice) {
            this.oldStagedPrice = oldStagedPrice;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

