/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.ProductPrice;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ProductPricesSet
implements MessagePayload {
    private Integer variantId;
    private List<ProductPrice> prices;
    private Boolean staged;
    private String type;

    public ProductPricesSet() {
    }

    public ProductPricesSet(Integer variantId, List<ProductPrice> prices, Boolean staged, String type) {
        this.variantId = variantId;
        this.prices = prices;
        this.staged = staged;
        this.type = type;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public List<ProductPrice> getPrices() {
        return this.prices;
    }

    public void setPrices(List<ProductPrice> prices) {
        this.prices = prices;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ProductPricesSet{variantId='" + this.variantId + "', prices='" + this.prices + "', staged='" + this.staged + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductPricesSet that = (ProductPricesSet)o;
        return Objects.equals(this.variantId, that.variantId) && Objects.equals(this.prices, that.prices) && Objects.equals(this.staged, that.staged) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.prices, this.staged, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer variantId;
        private List<ProductPrice> prices;
        private Boolean staged;
        private String type;

        public ProductPricesSet build() {
            ProductPricesSet result = new ProductPricesSet();
            result.variantId = this.variantId;
            result.prices = this.prices;
            result.staged = this.staged;
            result.type = this.type;
            return result;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder prices(List<ProductPrice> prices) {
            this.prices = prices;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

