/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.DeliveryDraft;
import com.commercetools.graphql.api.types.DiscountedLineItemPriceDraft;
import com.commercetools.graphql.api.types.MoneyInput;
import com.commercetools.graphql.api.types.ResourceIdentifierInput;
import com.commercetools.graphql.api.types.ShippingMethodState;
import com.commercetools.graphql.api.types.ShippingRateDraft;
import com.commercetools.graphql.api.types.TaxRateInput;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShippingInfoImportDraft {
    private String shippingMethodName;
    private MoneyInput price;
    private ShippingRateDraft shippingRate;
    private TaxRateInput taxRate;
    private ResourceIdentifierInput taxCategory;
    private List<DeliveryDraft> deliveries = Collections.emptyList();
    private ResourceIdentifierInput shippingMethod;
    private DiscountedLineItemPriceDraft discountedPrice;
    private ShippingMethodState shippingMethodState = ShippingMethodState.MatchesCart;

    public ShippingInfoImportDraft() {
    }

    public ShippingInfoImportDraft(String shippingMethodName, MoneyInput price, ShippingRateDraft shippingRate, TaxRateInput taxRate, ResourceIdentifierInput taxCategory, List<DeliveryDraft> deliveries, ResourceIdentifierInput shippingMethod, DiscountedLineItemPriceDraft discountedPrice, ShippingMethodState shippingMethodState) {
        this.shippingMethodName = shippingMethodName;
        this.price = price;
        this.shippingRate = shippingRate;
        this.taxRate = taxRate;
        this.taxCategory = taxCategory;
        this.deliveries = deliveries;
        this.shippingMethod = shippingMethod;
        this.discountedPrice = discountedPrice;
        this.shippingMethodState = shippingMethodState;
    }

    public String getShippingMethodName() {
        return this.shippingMethodName;
    }

    public void setShippingMethodName(String shippingMethodName) {
        this.shippingMethodName = shippingMethodName;
    }

    public MoneyInput getPrice() {
        return this.price;
    }

    public void setPrice(MoneyInput price) {
        this.price = price;
    }

    public ShippingRateDraft getShippingRate() {
        return this.shippingRate;
    }

    public void setShippingRate(ShippingRateDraft shippingRate) {
        this.shippingRate = shippingRate;
    }

    public TaxRateInput getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(TaxRateInput taxRate) {
        this.taxRate = taxRate;
    }

    public ResourceIdentifierInput getTaxCategory() {
        return this.taxCategory;
    }

    public void setTaxCategory(ResourceIdentifierInput taxCategory) {
        this.taxCategory = taxCategory;
    }

    public List<DeliveryDraft> getDeliveries() {
        return this.deliveries;
    }

    public void setDeliveries(List<DeliveryDraft> deliveries) {
        this.deliveries = deliveries;
    }

    public ResourceIdentifierInput getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public DiscountedLineItemPriceDraft getDiscountedPrice() {
        return this.discountedPrice;
    }

    public void setDiscountedPrice(DiscountedLineItemPriceDraft discountedPrice) {
        this.discountedPrice = discountedPrice;
    }

    public ShippingMethodState getShippingMethodState() {
        return this.shippingMethodState;
    }

    public void setShippingMethodState(ShippingMethodState shippingMethodState) {
        this.shippingMethodState = shippingMethodState;
    }

    public String toString() {
        return "ShippingInfoImportDraft{shippingMethodName='" + this.shippingMethodName + "', price='" + this.price + "', shippingRate='" + this.shippingRate + "', taxRate='" + this.taxRate + "', taxCategory='" + this.taxCategory + "', deliveries='" + this.deliveries + "', shippingMethod='" + this.shippingMethod + "', discountedPrice='" + this.discountedPrice + "', shippingMethodState='" + (Object)((Object)this.shippingMethodState) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingInfoImportDraft that = (ShippingInfoImportDraft)o;
        return Objects.equals(this.shippingMethodName, that.shippingMethodName) && Objects.equals(this.price, that.price) && Objects.equals(this.shippingRate, that.shippingRate) && Objects.equals(this.taxRate, that.taxRate) && Objects.equals(this.taxCategory, that.taxCategory) && Objects.equals(this.deliveries, that.deliveries) && Objects.equals(this.shippingMethod, that.shippingMethod) && Objects.equals(this.discountedPrice, that.discountedPrice) && Objects.equals((Object)this.shippingMethodState, (Object)that.shippingMethodState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shippingMethodName, this.price, this.shippingRate, this.taxRate, this.taxCategory, this.deliveries, this.shippingMethod, this.discountedPrice, this.shippingMethodState});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String shippingMethodName;
        private MoneyInput price;
        private ShippingRateDraft shippingRate;
        private TaxRateInput taxRate;
        private ResourceIdentifierInput taxCategory;
        private List<DeliveryDraft> deliveries = Collections.emptyList();
        private ResourceIdentifierInput shippingMethod;
        private DiscountedLineItemPriceDraft discountedPrice;
        private ShippingMethodState shippingMethodState = ShippingMethodState.MatchesCart;

        public ShippingInfoImportDraft build() {
            ShippingInfoImportDraft result = new ShippingInfoImportDraft();
            result.shippingMethodName = this.shippingMethodName;
            result.price = this.price;
            result.shippingRate = this.shippingRate;
            result.taxRate = this.taxRate;
            result.taxCategory = this.taxCategory;
            result.deliveries = this.deliveries;
            result.shippingMethod = this.shippingMethod;
            result.discountedPrice = this.discountedPrice;
            result.shippingMethodState = this.shippingMethodState;
            return result;
        }

        public Builder shippingMethodName(String shippingMethodName) {
            this.shippingMethodName = shippingMethodName;
            return this;
        }

        public Builder price(MoneyInput price) {
            this.price = price;
            return this;
        }

        public Builder shippingRate(ShippingRateDraft shippingRate) {
            this.shippingRate = shippingRate;
            return this;
        }

        public Builder taxRate(TaxRateInput taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxCategory(ResourceIdentifierInput taxCategory) {
            this.taxCategory = taxCategory;
            return this;
        }

        public Builder deliveries(List<DeliveryDraft> deliveries) {
            this.deliveries = deliveries;
            return this;
        }

        public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
            this.shippingMethod = shippingMethod;
            return this;
        }

        public Builder discountedPrice(DiscountedLineItemPriceDraft discountedPrice) {
            this.discountedPrice = discountedPrice;
            return this;
        }

        public Builder shippingMethodState(ShippingMethodState shippingMethodState) {
            this.shippingMethodState = shippingMethodState;
            return this;
        }
    }
}

