package com.commercetools.graphql.api;

import com.commercetools.graphql.api.types.APIClientWithSecret;
import com.commercetools.graphql.api.types.APIClientWithoutSecret;
import com.commercetools.graphql.api.types.APIClientWithoutSecretQueryResult;
import com.commercetools.graphql.api.types.ApprovalFlow;
import com.commercetools.graphql.api.types.ApprovalRule;
import com.commercetools.graphql.api.types.AsAssociate;
import com.commercetools.graphql.api.types.AssociateRole;
import com.commercetools.graphql.api.types.AssociateRoleQueryResult;
import com.commercetools.graphql.api.types.AttributeGroup;
import com.commercetools.graphql.api.types.AttributeGroupQueryResult;
import com.commercetools.graphql.api.types.BusinessUnit;
import com.commercetools.graphql.api.types.BusinessUnitQueryResult;
import com.commercetools.graphql.api.types.Cart;
import com.commercetools.graphql.api.types.CartDiscount;
import com.commercetools.graphql.api.types.CartDiscountQueryResult;
import com.commercetools.graphql.api.types.CartQueryResult;
import com.commercetools.graphql.api.types.Category;
import com.commercetools.graphql.api.types.CategoryQueryResult;
import com.commercetools.graphql.api.types.Channel;
import com.commercetools.graphql.api.types.ChannelQueryResult;
import com.commercetools.graphql.api.types.CommercetoolsSubscription;
import com.commercetools.graphql.api.types.CommercetoolsSubscriptionQueryResult;
import com.commercetools.graphql.api.types.CustomObject;
import com.commercetools.graphql.api.types.CustomObjectQueryResult;
import com.commercetools.graphql.api.types.Customer;
import com.commercetools.graphql.api.types.CustomerEmailToken;
import com.commercetools.graphql.api.types.CustomerGroup;
import com.commercetools.graphql.api.types.CustomerGroupQueryResult;
import com.commercetools.graphql.api.types.CustomerPasswordToken;
import com.commercetools.graphql.api.types.CustomerQueryResult;
import com.commercetools.graphql.api.types.CustomerSignInResult;
import com.commercetools.graphql.api.types.DiscountCode;
import com.commercetools.graphql.api.types.DiscountCodeQueryResult;
import com.commercetools.graphql.api.types.Extension;
import com.commercetools.graphql.api.types.ExtensionQueryResult;
import com.commercetools.graphql.api.types.InStore;
import com.commercetools.graphql.api.types.InventoryEntry;
import com.commercetools.graphql.api.types.InventoryEntryQueryResult;
import com.commercetools.graphql.api.types.Me;
import com.commercetools.graphql.api.types.Message;
import com.commercetools.graphql.api.types.MessageQueryResult;
import com.commercetools.graphql.api.types.MyPayment;
import com.commercetools.graphql.api.types.Order;
import com.commercetools.graphql.api.types.OrderEdit;
import com.commercetools.graphql.api.types.OrderEditQueryResult;
import com.commercetools.graphql.api.types.OrderQueryResult;
import com.commercetools.graphql.api.types.Payment;
import com.commercetools.graphql.api.types.PaymentQueryResult;
import com.commercetools.graphql.api.types.Product;
import com.commercetools.graphql.api.types.ProductAssignmentQueryResult;
import com.commercetools.graphql.api.types.ProductDiscount;
import com.commercetools.graphql.api.types.ProductDiscountQueryResult;
import com.commercetools.graphql.api.types.ProductProjectionSearchResult;
import com.commercetools.graphql.api.types.ProductQueryResult;
import com.commercetools.graphql.api.types.ProductSelection;
import com.commercetools.graphql.api.types.ProductSelectionQueryResult;
import com.commercetools.graphql.api.types.ProductTailoring;
import com.commercetools.graphql.api.types.ProductTailoringQueryResult;
import com.commercetools.graphql.api.types.ProductTypeDefinition;
import com.commercetools.graphql.api.types.ProductTypeDefinitionQueryResult;
import com.commercetools.graphql.api.types.ProjectCustomLimitsProjection;
import com.commercetools.graphql.api.types.ProjectProjection;
import com.commercetools.graphql.api.types.Quote;
import com.commercetools.graphql.api.types.QuoteQueryResult;
import com.commercetools.graphql.api.types.QuoteRequest;
import com.commercetools.graphql.api.types.QuoteRequestQueryResult;
import com.commercetools.graphql.api.types.Review;
import com.commercetools.graphql.api.types.ReviewQueryResult;
import com.commercetools.graphql.api.types.ShippingMethod;
import com.commercetools.graphql.api.types.ShippingMethodQueryResult;
import com.commercetools.graphql.api.types.ShoppingList;
import com.commercetools.graphql.api.types.ShoppingListQueryResult;
import com.commercetools.graphql.api.types.StagedQuote;
import com.commercetools.graphql.api.types.StagedQuoteQueryResult;
import com.commercetools.graphql.api.types.StandalonePrice;
import com.commercetools.graphql.api.types.StandalonePriceQueryResult;
import com.commercetools.graphql.api.types.State;
import com.commercetools.graphql.api.types.StateQueryResult;
import com.commercetools.graphql.api.types.Store;
import com.commercetools.graphql.api.types.StoreQueryResult;
import com.commercetools.graphql.api.types.SuggestResult;
import com.commercetools.graphql.api.types.TaxCategory;
import com.commercetools.graphql.api.types.TaxCategoryQueryResult;
import com.commercetools.graphql.api.types.TypeDefinition;
import com.commercetools.graphql.api.types.TypeDefinitionQueryResult;
import com.commercetools.graphql.api.types.Zone;
import com.commercetools.graphql.api.types.ZoneQueryResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(
    as = GraphQLDataImpl.class
)
public interface GraphQLData {
  default <T> T get(GraphQLRequest<T> request) {
    return request.getDataMapper().apply(this);
  }

  @JsonProperty("deleteExtension")
  Extension getDeleteExtension();

  void setDeleteExtension(Extension deleteExtension);

  @JsonProperty("createShippingMethod")
  ShippingMethod getCreateShippingMethod();

  void setCreateShippingMethod(ShippingMethod createShippingMethod);

  @JsonProperty("createStandalonePrice")
  StandalonePrice getCreateStandalonePrice();

  void setCreateStandalonePrice(StandalonePrice createStandalonePrice);

  @JsonProperty("deleteCustomer")
  Customer getDeleteCustomer();

  void setDeleteCustomer(Customer deleteCustomer);

  @JsonProperty("deleteAttributeGroup")
  AttributeGroup getDeleteAttributeGroup();

  void setDeleteAttributeGroup(AttributeGroup deleteAttributeGroup);

  @JsonProperty("states")
  StateQueryResult getStates();

  void setStates(StateQueryResult states);

  @JsonProperty("updateSubscription")
  CommercetoolsSubscription getUpdateSubscription();

  void setUpdateSubscription(CommercetoolsSubscription updateSubscription);

  @JsonProperty("updateCustomerGroup")
  CustomerGroup getUpdateCustomerGroup();

  void setUpdateCustomerGroup(CustomerGroup updateCustomerGroup);

  @JsonProperty("updateOrder")
  Order getUpdateOrder();

  void setUpdateOrder(Order updateOrder);

  @JsonProperty("updateDiscountCode")
  DiscountCode getUpdateDiscountCode();

  void setUpdateDiscountCode(DiscountCode updateDiscountCode);

  @JsonProperty("deleteTaxCategory")
  TaxCategory getDeleteTaxCategory();

  void setDeleteTaxCategory(TaxCategory deleteTaxCategory);

  @JsonProperty("productType")
  ProductTypeDefinition getProductType();

  void setProductType(ProductTypeDefinition productType);

  @JsonProperty("updateQuote")
  Quote getUpdateQuote();

  void setUpdateQuote(Quote updateQuote);

  @JsonProperty("updateMyBusinessUnit")
  BusinessUnit getUpdateMyBusinessUnit();

  void setUpdateMyBusinessUnit(BusinessUnit updateMyBusinessUnit);

  @JsonProperty("orderEdits")
  OrderEditQueryResult getOrderEdits();

  void setOrderEdits(OrderEditQueryResult orderEdits);

  @JsonProperty("inStore")
  InStore getInStore();

  void setInStore(InStore inStore);

  @JsonProperty("createAssociateRole")
  AssociateRole getCreateAssociateRole();

  void setCreateAssociateRole(AssociateRole createAssociateRole);

  @JsonProperty("importOrder")
  Order getImportOrder();

  void setImportOrder(Order importOrder);

  @JsonProperty("createApprovalRule")
  ApprovalRule getCreateApprovalRule();

  void setCreateApprovalRule(ApprovalRule createApprovalRule);

  @JsonProperty("productSelections")
  ProductSelectionQueryResult getProductSelections();

  void setProductSelections(ProductSelectionQueryResult productSelections);

  @JsonProperty("updateMyCart")
  Cart getUpdateMyCart();

  void setUpdateMyCart(Cart updateMyCart);

  @JsonProperty("deletePayment")
  Payment getDeletePayment();

  void setDeletePayment(Payment deletePayment);

  @JsonProperty("state")
  State getState();

  void setState(State state);

  @JsonProperty("deleteProductType")
  ProductTypeDefinition getDeleteProductType();

  void setDeleteProductType(ProductTypeDefinition deleteProductType);

  @JsonProperty("deleteStagedQuote")
  StagedQuote getDeleteStagedQuote();

  void setDeleteStagedQuote(StagedQuote deleteStagedQuote);

  @JsonProperty("me")
  Me getMe();

  void setMe(Me me);

  @JsonProperty("extensions")
  ExtensionQueryResult getExtensions();

  void setExtensions(ExtensionQueryResult extensions);

  @JsonProperty("updateInventoryEntry")
  InventoryEntry getUpdateInventoryEntry();

  void setUpdateInventoryEntry(InventoryEntry updateInventoryEntry);

  @JsonProperty("createChannel")
  Channel getCreateChannel();

  void setCreateChannel(Channel createChannel);

  @JsonProperty("project")
  ProjectProjection getProject();

  void setProject(ProjectProjection project);

  @JsonProperty("customObject")
  CustomObject getCustomObject();

  void setCustomObject(CustomObject customObject);

  @JsonProperty("updateMyQuoteRequest")
  QuoteRequest getUpdateMyQuoteRequest();

  void setUpdateMyQuoteRequest(QuoteRequest updateMyQuoteRequest);

  @JsonProperty("zone")
  Zone getZone();

  void setZone(Zone zone);

  @JsonProperty("associateRole")
  AssociateRole getAssociateRole();

  void setAssociateRole(AssociateRole associateRole);

  @JsonProperty("productProjectionsSuggest")
  SuggestResult getProductProjectionsSuggest();

  void setProductProjectionsSuggest(SuggestResult productProjectionsSuggest);

  @JsonProperty("subscription")
  CommercetoolsSubscription getSubscription();

  void setSubscription(CommercetoolsSubscription subscription);

  @JsonProperty("createStore")
  Store getCreateStore();

  void setCreateStore(Store createStore);

  @JsonProperty("createTypeDefinition")
  TypeDefinition getCreateTypeDefinition();

  void setCreateTypeDefinition(TypeDefinition createTypeDefinition);

  @JsonProperty("stores")
  StoreQueryResult getStores();

  void setStores(StoreQueryResult stores);

  @JsonProperty("createProductDiscount")
  ProductDiscount getCreateProductDiscount();

  void setCreateProductDiscount(ProductDiscount createProductDiscount);

  @JsonProperty("createMyOrderFromCart")
  Order getCreateMyOrderFromCart();

  void setCreateMyOrderFromCart(Order createMyOrderFromCart);

  @JsonProperty("deleteShoppingList")
  ShoppingList getDeleteShoppingList();

  void setDeleteShoppingList(ShoppingList deleteShoppingList);

  @JsonProperty("extension")
  Extension getExtension();

  void setExtension(Extension extension);

  @JsonProperty("attributeGroup")
  AttributeGroup getAttributeGroup();

  void setAttributeGroup(AttributeGroup attributeGroup);

  @JsonProperty("productSelection")
  ProductSelection getProductSelection();

  void setProductSelection(ProductSelection productSelection);

  @JsonProperty("deleteCategory")
  Category getDeleteCategory();

  void setDeleteCategory(Category deleteCategory);

  @JsonProperty("messages")
  MessageQueryResult getMessages();

  void setMessages(MessageQueryResult messages);

  @JsonProperty("createProduct")
  Product getCreateProduct();

  void setCreateProduct(Product createProduct);

  @JsonProperty("signUpInMyBusinessUnit")
  CustomerSignInResult getSignUpInMyBusinessUnit();

  void setSignUpInMyBusinessUnit(CustomerSignInResult signUpInMyBusinessUnit);

  @JsonProperty("businessUnits")
  BusinessUnitQueryResult getBusinessUnits();

  void setBusinessUnits(BusinessUnitQueryResult businessUnits);

  @JsonProperty("updateStandalonePrice")
  StandalonePrice getUpdateStandalonePrice();

  void setUpdateStandalonePrice(StandalonePrice updateStandalonePrice);

  @JsonProperty("shippingMethod")
  ShippingMethod getShippingMethod();

  void setShippingMethod(ShippingMethod shippingMethod);

  @JsonProperty("createQuoteRequest")
  QuoteRequest getCreateQuoteRequest();

  void setCreateQuoteRequest(QuoteRequest createQuoteRequest);

  @JsonProperty("deleteState")
  State getDeleteState();

  void setDeleteState(State deleteState);

  @JsonProperty("updateZone")
  Zone getUpdateZone();

  void setUpdateZone(Zone updateZone);

  @JsonProperty("deleteMyCustomer")
  Customer getDeleteMyCustomer();

  void setDeleteMyCustomer(Customer deleteMyCustomer);

  @JsonProperty("createState")
  State getCreateState();

  void setCreateState(State createState);

  @JsonProperty("productSelectionAssignments")
  ProductAssignmentQueryResult getProductSelectionAssignments();

  void setProductSelectionAssignments(ProductAssignmentQueryResult productSelectionAssignments);

  @JsonProperty("productTypes")
  ProductTypeDefinitionQueryResult getProductTypes();

  void setProductTypes(ProductTypeDefinitionQueryResult productTypes);

  @JsonProperty("customerSignIn")
  CustomerSignInResult getCustomerSignIn();

  void setCustomerSignIn(CustomerSignInResult customerSignIn);

  @JsonProperty("updateMyQuote")
  Quote getUpdateMyQuote();

  void setUpdateMyQuote(Quote updateMyQuote);

  @JsonProperty("category")
  Category getCategory();

  void setCategory(Category category);

  @JsonProperty("createProductType")
  ProductTypeDefinition getCreateProductType();

  void setCreateProductType(ProductTypeDefinition createProductType);

  @JsonProperty("categories")
  CategoryQueryResult getCategories();

  void setCategories(CategoryQueryResult categories);

  @JsonProperty("updateCart")
  Cart getUpdateCart();

  void setUpdateCart(Cart updateCart);

  @JsonProperty("createProductSelection")
  ProductSelection getCreateProductSelection();

  void setCreateProductSelection(ProductSelection createProductSelection);

  @JsonProperty("customerGroups")
  CustomerGroupQueryResult getCustomerGroups();

  void setCustomerGroups(CustomerGroupQueryResult customerGroups);

  @JsonProperty("deleteCartDiscount")
  CartDiscount getDeleteCartDiscount();

  void setDeleteCartDiscount(CartDiscount deleteCartDiscount);

  @JsonProperty("cartDiscount")
  CartDiscount getCartDiscount();

  void setCartDiscount(CartDiscount cartDiscount);

  @JsonProperty("businessUnit")
  BusinessUnit getBusinessUnit();

  void setBusinessUnit(BusinessUnit businessUnit);

  @JsonProperty("createShoppingList")
  ShoppingList getCreateShoppingList();

  void setCreateShoppingList(ShoppingList createShoppingList);

  @JsonProperty("apiClient")
  APIClientWithoutSecret getApiClient();

  void setApiClient(APIClientWithoutSecret apiClient);

  @JsonProperty("customerConfirmMyEmail")
  Customer getCustomerConfirmMyEmail();

  void setCustomerConfirmMyEmail(Customer customerConfirmMyEmail);

  @JsonProperty("orders")
  OrderQueryResult getOrders();

  void setOrders(OrderQueryResult orders);

  @JsonProperty("inventoryEntries")
  InventoryEntryQueryResult getInventoryEntries();

  void setInventoryEntries(InventoryEntryQueryResult inventoryEntries);

  @JsonProperty("attributeGroups")
  AttributeGroupQueryResult getAttributeGroups();

  void setAttributeGroups(AttributeGroupQueryResult attributeGroups);

  @JsonProperty("shoppingList")
  ShoppingList getShoppingList();

  void setShoppingList(ShoppingList shoppingList);

  @JsonProperty("customer")
  Customer getCustomer();

  void setCustomer(Customer customer);

  @JsonProperty("stagedQuotes")
  StagedQuoteQueryResult getStagedQuotes();

  void setStagedQuotes(StagedQuoteQueryResult stagedQuotes);

  @JsonProperty("updateProject")
  ProjectProjection getUpdateProject();

  void setUpdateProject(ProjectProjection updateProject);

  @JsonProperty("carts")
  CartQueryResult getCarts();

  void setCarts(CartQueryResult carts);

  @JsonProperty("deleteStore")
  Store getDeleteStore();

  void setDeleteStore(Store deleteStore);

  @JsonProperty("createQuote")
  Quote getCreateQuote();

  void setCreateQuote(Quote createQuote);

  @JsonProperty("productProjectionSearch")
  ProductProjectionSearchResult getProductProjectionSearch();

  void setProductProjectionSearch(ProductProjectionSearchResult productProjectionSearch);

  @JsonProperty("createApiClient")
  APIClientWithSecret getCreateApiClient();

  void setCreateApiClient(APIClientWithSecret createApiClient);

  @JsonProperty("customerConfirmEmail")
  Customer getCustomerConfirmEmail();

  void setCustomerConfirmEmail(Customer customerConfirmEmail);

  @JsonProperty("deleteTypeDefinition")
  TypeDefinition getDeleteTypeDefinition();

  void setDeleteTypeDefinition(TypeDefinition deleteTypeDefinition);

  @JsonProperty("productDiscount")
  ProductDiscount getProductDiscount();

  void setProductDiscount(ProductDiscount productDiscount);

  @JsonProperty("deleteMyPayment")
  MyPayment getDeleteMyPayment();

  void setDeleteMyPayment(MyPayment deleteMyPayment);

  @JsonProperty("createMyBusinessUnit")
  BusinessUnit getCreateMyBusinessUnit();

  void setCreateMyBusinessUnit(BusinessUnit createMyBusinessUnit);

  @JsonProperty("discountCode")
  DiscountCode getDiscountCode();

  void setDiscountCode(DiscountCode discountCode);

  @JsonProperty("channels")
  ChannelQueryResult getChannels();

  void setChannels(ChannelQueryResult channels);

  @JsonProperty("store")
  Store getStore();

  void setStore(Store store);

  @JsonProperty("createMyShoppingList")
  ShoppingList getCreateMyShoppingList();

  void setCreateMyShoppingList(ShoppingList createMyShoppingList);

  @JsonProperty("deleteMyCart")
  Cart getDeleteMyCart();

  void setDeleteMyCart(Cart deleteMyCart);

  @JsonProperty("quoteRequest")
  QuoteRequest getQuoteRequest();

  void setQuoteRequest(QuoteRequest quoteRequest);

  @JsonProperty("createExtension")
  Extension getCreateExtension();

  void setCreateExtension(Extension createExtension);

  @JsonProperty("createPayment")
  Payment getCreatePayment();

  void setCreatePayment(Payment createPayment);

  @JsonProperty("updateMyCustomer")
  Customer getUpdateMyCustomer();

  void setUpdateMyCustomer(Customer updateMyCustomer);

  @JsonProperty("products")
  ProductQueryResult getProducts();

  void setProducts(ProductQueryResult products);

  @JsonProperty("createCategory")
  Category getCreateCategory();

  void setCreateCategory(Category createCategory);

  @JsonProperty("deleteZone")
  Zone getDeleteZone();

  void setDeleteZone(Zone deleteZone);

  @JsonProperty("deleteDiscountCode")
  DiscountCode getDeleteDiscountCode();

  void setDeleteDiscountCode(DiscountCode deleteDiscountCode);

  @JsonProperty("inStores")
  InStore getInStores();

  void setInStores(InStore inStores);

  @JsonProperty("deleteBusinessUnit")
  BusinessUnit getDeleteBusinessUnit();

  void setDeleteBusinessUnit(BusinessUnit deleteBusinessUnit);

  @JsonProperty("deleteProductSelection")
  ProductSelection getDeleteProductSelection();

  void setDeleteProductSelection(ProductSelection deleteProductSelection);

  @JsonProperty("createProductTailoring")
  ProductTailoring getCreateProductTailoring();

  void setCreateProductTailoring(ProductTailoring createProductTailoring);

  @JsonProperty("customerChangeMyPassword")
  Customer getCustomerChangeMyPassword();

  void setCustomerChangeMyPassword(Customer customerChangeMyPassword);

  @JsonProperty("createCartDiscount")
  CartDiscount getCreateCartDiscount();

  void setCreateCartDiscount(CartDiscount createCartDiscount);

  @JsonProperty("quote")
  Quote getQuote();

  void setQuote(Quote quote);

  @JsonProperty("taxCategories")
  TaxCategoryQueryResult getTaxCategories();

  void setTaxCategories(TaxCategoryQueryResult taxCategories);

  @JsonProperty("customerResetMyPassword")
  Customer getCustomerResetMyPassword();

  void setCustomerResetMyPassword(Customer customerResetMyPassword);

  @JsonProperty("reviews")
  ReviewQueryResult getReviews();

  void setReviews(ReviewQueryResult reviews);

  @JsonProperty("asAssociate")
  AsAssociate getAsAssociate();

  void setAsAssociate(AsAssociate asAssociate);

  @JsonProperty("updateShippingMethod")
  ShippingMethod getUpdateShippingMethod();

  void setUpdateShippingMethod(ShippingMethod updateShippingMethod);

  @JsonProperty("customerCreateEmailVerificationToken")
  CustomerEmailToken getCustomerCreateEmailVerificationToken();

  void setCustomerCreateEmailVerificationToken(
      CustomerEmailToken customerCreateEmailVerificationToken);

  @JsonProperty("deleteShippingMethod")
  ShippingMethod getDeleteShippingMethod();

  void setDeleteShippingMethod(ShippingMethod deleteShippingMethod);

  @JsonProperty("replicateCart")
  Cart getReplicateCart();

  void setReplicateCart(Cart replicateCart);

  @JsonProperty("updateProductType")
  ProductTypeDefinition getUpdateProductType();

  void setUpdateProductType(ProductTypeDefinition updateProductType);

  @JsonProperty("updateReview")
  Review getUpdateReview();

  void setUpdateReview(Review updateReview);

  @JsonProperty("quoteRequests")
  QuoteRequestQueryResult getQuoteRequests();

  void setQuoteRequests(QuoteRequestQueryResult quoteRequests);

  @JsonProperty("deleteReview")
  Review getDeleteReview();

  void setDeleteReview(Review deleteReview);

  @JsonProperty("payments")
  PaymentQueryResult getPayments();

  void setPayments(PaymentQueryResult payments);

  @JsonProperty("updateState")
  State getUpdateState();

  void setUpdateState(State updateState);

  @JsonProperty("shippingMethodsByLocation")
  ShippingMethod getShippingMethodsByLocation();

  void setShippingMethodsByLocation(ShippingMethod shippingMethodsByLocation);

  @JsonProperty("deleteInventoryEntry")
  InventoryEntry getDeleteInventoryEntry();

  void setDeleteInventoryEntry(InventoryEntry deleteInventoryEntry);

  @JsonProperty("updateChannel")
  Channel getUpdateChannel();

  void setUpdateChannel(Channel updateChannel);

  @JsonProperty("deleteStandalonePrice")
  StandalonePrice getDeleteStandalonePrice();

  void setDeleteStandalonePrice(StandalonePrice deleteStandalonePrice);

  @JsonProperty("updateTypeDefinition")
  TypeDefinition getUpdateTypeDefinition();

  void setUpdateTypeDefinition(TypeDefinition updateTypeDefinition);

  @JsonProperty("channel")
  Channel getChannel();

  void setChannel(Channel channel);

  @JsonProperty("customerSignMeIn")
  CustomerSignInResult getCustomerSignMeIn();

  void setCustomerSignMeIn(CustomerSignInResult customerSignMeIn);

  @JsonProperty("inventoryEntry")
  InventoryEntry getInventoryEntry();

  void setInventoryEntry(InventoryEntry inventoryEntry);

  @JsonProperty("customers")
  CustomerQueryResult getCustomers();

  void setCustomers(CustomerQueryResult customers);

  @JsonProperty("customerSignMeUp")
  CustomerSignInResult getCustomerSignMeUp();

  void setCustomerSignMeUp(CustomerSignInResult customerSignMeUp);

  @JsonProperty("associateRoles")
  AssociateRoleQueryResult getAssociateRoles();

  void setAssociateRoles(AssociateRoleQueryResult associateRoles);

  @JsonProperty("cartDiscounts")
  CartDiscountQueryResult getCartDiscounts();

  void setCartDiscounts(CartDiscountQueryResult cartDiscounts);

  @JsonProperty("createCart")
  Cart getCreateCart();

  void setCreateCart(Cart createCart);

  @JsonProperty("createCustomerGroup")
  CustomerGroup getCreateCustomerGroup();

  void setCreateCustomerGroup(CustomerGroup createCustomerGroup);

  @JsonProperty("order")
  Order getOrder();

  void setOrder(Order order);

  @JsonProperty("customerGroup")
  CustomerGroup getCustomerGroup();

  void setCustomerGroup(CustomerGroup customerGroup);

  @JsonProperty("zones")
  ZoneQueryResult getZones();

  void setZones(ZoneQueryResult zones);

  @JsonProperty("createReview")
  Review getCreateReview();

  void setCreateReview(Review createReview);

  @JsonProperty("createDiscountCode")
  DiscountCode getCreateDiscountCode();

  void setCreateDiscountCode(DiscountCode createDiscountCode);

  @JsonProperty("deleteApiClient")
  APIClientWithoutSecret getDeleteApiClient();

  void setDeleteApiClient(APIClientWithoutSecret deleteApiClient);

  @JsonProperty("productTailoring")
  ProductTailoring getProductTailoring();

  void setProductTailoring(ProductTailoring productTailoring);

  @JsonProperty("createMyCart")
  Cart getCreateMyCart();

  void setCreateMyCart(Cart createMyCart);

  @JsonProperty("deleteAssociateRole")
  AssociateRole getDeleteAssociateRole();

  void setDeleteAssociateRole(AssociateRole deleteAssociateRole);

  @JsonProperty("deleteOrder")
  Order getDeleteOrder();

  void setDeleteOrder(Order deleteOrder);

  @JsonProperty("apiClients")
  APIClientWithoutSecretQueryResult getApiClients();

  void setApiClients(APIClientWithoutSecretQueryResult apiClients);

  @JsonProperty("deleteQuote")
  Quote getDeleteQuote();

  void setDeleteQuote(Quote deleteQuote);

  @JsonProperty("createTaxCategory")
  TaxCategory getCreateTaxCategory();

  void setCreateTaxCategory(TaxCategory createTaxCategory);

  @JsonProperty("updateApprovalRule")
  ApprovalRule getUpdateApprovalRule();

  void setUpdateApprovalRule(ApprovalRule updateApprovalRule);

  @JsonProperty("createMyQuoteRequest")
  QuoteRequest getCreateMyQuoteRequest();

  void setCreateMyQuoteRequest(QuoteRequest createMyQuoteRequest);

  @JsonProperty("review")
  Review getReview();

  void setReview(Review review);

  @JsonProperty("createZone")
  Zone getCreateZone();

  void setCreateZone(Zone createZone);

  @JsonProperty("createInventoryEntry")
  InventoryEntry getCreateInventoryEntry();

  void setCreateInventoryEntry(InventoryEntry createInventoryEntry);

  @JsonProperty("createBusinessUnit")
  BusinessUnit getCreateBusinessUnit();

  void setCreateBusinessUnit(BusinessUnit createBusinessUnit);

  @JsonProperty("deleteCart")
  Cart getDeleteCart();

  void setDeleteCart(Cart deleteCart);

  @JsonProperty("deleteProductDiscount")
  ProductDiscount getDeleteProductDiscount();

  void setDeleteProductDiscount(ProductDiscount deleteProductDiscount);

  @JsonProperty("updateProduct")
  Product getUpdateProduct();

  void setUpdateProduct(Product updateProduct);

  @JsonProperty("updateApprovalFlow")
  ApprovalFlow getUpdateApprovalFlow();

  void setUpdateApprovalFlow(ApprovalFlow updateApprovalFlow);

  @JsonProperty("updateStore")
  Store getUpdateStore();

  void setUpdateStore(Store updateStore);

  @JsonProperty("product")
  Product getProduct();

  void setProduct(Product product);

  @JsonProperty("createMyOrderFromQuote")
  Order getCreateMyOrderFromQuote();

  void setCreateMyOrderFromQuote(Order createMyOrderFromQuote);

  @JsonProperty("createStagedQuote")
  StagedQuote getCreateStagedQuote();

  void setCreateStagedQuote(StagedQuote createStagedQuote);

  @JsonProperty("deleteQuoteRequest")
  QuoteRequest getDeleteQuoteRequest();

  void setDeleteQuoteRequest(QuoteRequest deleteQuoteRequest);

  @JsonProperty("updatePayment")
  Payment getUpdatePayment();

  void setUpdatePayment(Payment updatePayment);

  @JsonProperty("updateMyPayment")
  MyPayment getUpdateMyPayment();

  void setUpdateMyPayment(MyPayment updateMyPayment);

  @JsonProperty("customObjects")
  CustomObjectQueryResult getCustomObjects();

  void setCustomObjects(CustomObjectQueryResult customObjects);

  @JsonProperty("typeDefinition")
  TypeDefinition getTypeDefinition();

  void setTypeDefinition(TypeDefinition typeDefinition);

  @JsonProperty("limits")
  ProjectCustomLimitsProjection getLimits();

  void setLimits(ProjectCustomLimitsProjection limits);

  @JsonProperty("productDiscounts")
  ProductDiscountQueryResult getProductDiscounts();

  void setProductDiscounts(ProductDiscountQueryResult productDiscounts);

  @JsonProperty("deleteChannel")
  Channel getDeleteChannel();

  void setDeleteChannel(Channel deleteChannel);

  @JsonProperty("updateMyShoppingList")
  ShoppingList getUpdateMyShoppingList();

  void setUpdateMyShoppingList(ShoppingList updateMyShoppingList);

  @JsonProperty("discountCodes")
  DiscountCodeQueryResult getDiscountCodes();

  void setDiscountCodes(DiscountCodeQueryResult discountCodes);

  @JsonProperty("shippingMethodsByCart")
  ShippingMethod getShippingMethodsByCart();

  void setShippingMethodsByCart(ShippingMethod shippingMethodsByCart);

  @JsonProperty("updateAttributeGroup")
  AttributeGroup getUpdateAttributeGroup();

  void setUpdateAttributeGroup(AttributeGroup updateAttributeGroup);

  @JsonProperty("stagedQuote")
  StagedQuote getStagedQuote();

  void setStagedQuote(StagedQuote stagedQuote);

  @JsonProperty("deleteMyShoppingList")
  ShoppingList getDeleteMyShoppingList();

  void setDeleteMyShoppingList(ShoppingList deleteMyShoppingList);

  @JsonProperty("createMyPayment")
  MyPayment getCreateMyPayment();

  void setCreateMyPayment(MyPayment createMyPayment);

  @JsonProperty("shoppingLists")
  ShoppingListQueryResult getShoppingLists();

  void setShoppingLists(ShoppingListQueryResult shoppingLists);

  @JsonProperty("updateProductSelection")
  ProductSelection getUpdateProductSelection();

  void setUpdateProductSelection(ProductSelection updateProductSelection);

  @JsonProperty("createOrderFromCart")
  Order getCreateOrderFromCart();

  void setCreateOrderFromCart(Order createOrderFromCart);

  @JsonProperty("subscriptions")
  CommercetoolsSubscriptionQueryResult getSubscriptions();

  void setSubscriptions(CommercetoolsSubscriptionQueryResult subscriptions);

  @JsonProperty("taxCategory")
  TaxCategory getTaxCategory();

  void setTaxCategory(TaxCategory taxCategory);

  @JsonProperty("updateBusinessUnit")
  BusinessUnit getUpdateBusinessUnit();

  void setUpdateBusinessUnit(BusinessUnit updateBusinessUnit);

  @JsonProperty("customerResetPassword")
  Customer getCustomerResetPassword();

  void setCustomerResetPassword(Customer customerResetPassword);

  @JsonProperty("createSubscription")
  CommercetoolsSubscription getCreateSubscription();

  void setCreateSubscription(CommercetoolsSubscription createSubscription);

  @JsonProperty("customerChangePassword")
  Customer getCustomerChangePassword();

  void setCustomerChangePassword(Customer customerChangePassword);

  @JsonProperty("createOrUpdateCustomObject")
  CustomObject getCreateOrUpdateCustomObject();

  void setCreateOrUpdateCustomObject(CustomObject createOrUpdateCustomObject);

  @JsonProperty("message")
  Message getMessage();

  void setMessage(Message message);

  @JsonProperty("customerCreatePasswordResetToken")
  CustomerPasswordToken getCustomerCreatePasswordResetToken();

  void setCustomerCreatePasswordResetToken(CustomerPasswordToken customerCreatePasswordResetToken);

  @JsonProperty("standalonePrices")
  StandalonePriceQueryResult getStandalonePrices();

  void setStandalonePrices(StandalonePriceQueryResult standalonePrices);

  @JsonProperty("updateShoppingList")
  ShoppingList getUpdateShoppingList();

  void setUpdateShoppingList(ShoppingList updateShoppingList);

  @JsonProperty("payment")
  Payment getPayment();

  void setPayment(Payment payment);

  @JsonProperty("customerActiveCart")
  Cart getCustomerActiveCart();

  void setCustomerActiveCart(Cart customerActiveCart);

  @JsonProperty("createAttributeGroup")
  AttributeGroup getCreateAttributeGroup();

  void setCreateAttributeGroup(AttributeGroup createAttributeGroup);

  @JsonProperty("createOrderFromQuote")
  Order getCreateOrderFromQuote();

  void setCreateOrderFromQuote(Order createOrderFromQuote);

  @JsonProperty("deleteCustomerGroup")
  CustomerGroup getDeleteCustomerGroup();

  void setDeleteCustomerGroup(CustomerGroup deleteCustomerGroup);

  @JsonProperty("deleteCustomObject")
  CustomObject getDeleteCustomObject();

  void setDeleteCustomObject(CustomObject deleteCustomObject);

  @JsonProperty("deleteProduct")
  Product getDeleteProduct();

  void setDeleteProduct(Product deleteProduct);

  @JsonProperty("updateTaxCategory")
  TaxCategory getUpdateTaxCategory();

  void setUpdateTaxCategory(TaxCategory updateTaxCategory);

  @JsonProperty("updateProductTailoring")
  ProductTailoring getUpdateProductTailoring();

  void setUpdateProductTailoring(ProductTailoring updateProductTailoring);

  @JsonProperty("deleteSubscription")
  CommercetoolsSubscription getDeleteSubscription();

  void setDeleteSubscription(CommercetoolsSubscription deleteSubscription);

  @JsonProperty("productTailoringList")
  ProductTailoringQueryResult getProductTailoringList();

  void setProductTailoringList(ProductTailoringQueryResult productTailoringList);

  @JsonProperty("standalonePrice")
  StandalonePrice getStandalonePrice();

  void setStandalonePrice(StandalonePrice standalonePrice);

  @JsonProperty("updateAssociateRole")
  AssociateRole getUpdateAssociateRole();

  void setUpdateAssociateRole(AssociateRole updateAssociateRole);

  @JsonProperty("createOrderEdit")
  OrderEdit getCreateOrderEdit();

  void setCreateOrderEdit(OrderEdit createOrderEdit);

  @JsonProperty("replicateMyCart")
  Cart getReplicateMyCart();

  void setReplicateMyCart(Cart replicateMyCart);

  @JsonProperty("updateProductDiscount")
  ProductDiscount getUpdateProductDiscount();

  void setUpdateProductDiscount(ProductDiscount updateProductDiscount);

  @JsonProperty("updateOrderEdit")
  OrderEdit getUpdateOrderEdit();

  void setUpdateOrderEdit(OrderEdit updateOrderEdit);

  @JsonProperty("updateExtension")
  Extension getUpdateExtension();

  void setUpdateExtension(Extension updateExtension);

  @JsonProperty("updateCustomer")
  Customer getUpdateCustomer();

  void setUpdateCustomer(Customer updateCustomer);

  @JsonProperty("typeDefinitions")
  TypeDefinitionQueryResult getTypeDefinitions();

  void setTypeDefinitions(TypeDefinitionQueryResult typeDefinitions);

  @JsonProperty("updateStagedQuote")
  StagedQuote getUpdateStagedQuote();

  void setUpdateStagedQuote(StagedQuote updateStagedQuote);

  @JsonProperty("customerSignUp")
  CustomerSignInResult getCustomerSignUp();

  void setCustomerSignUp(CustomerSignInResult customerSignUp);

  @JsonProperty("deleteProductTailoring")
  ProductTailoring getDeleteProductTailoring();

  void setDeleteProductTailoring(ProductTailoring deleteProductTailoring);

  @JsonProperty("updateCartDiscount")
  CartDiscount getUpdateCartDiscount();

  void setUpdateCartDiscount(CartDiscount updateCartDiscount);

  @JsonProperty("shippingMethods")
  ShippingMethodQueryResult getShippingMethods();

  void setShippingMethods(ShippingMethodQueryResult shippingMethods);

  @JsonProperty("orderEdit")
  OrderEdit getOrderEdit();

  void setOrderEdit(OrderEdit orderEdit);

  @JsonProperty("updateCategory")
  Category getUpdateCategory();

  void setUpdateCategory(Category updateCategory);

  @JsonProperty("cart")
  Cart getCart();

  void setCart(Cart cart);

  @JsonProperty("deleteOrderEdit")
  OrderEdit getDeleteOrderEdit();

  void setDeleteOrderEdit(OrderEdit deleteOrderEdit);

  @JsonProperty("updateQuoteRequest")
  QuoteRequest getUpdateQuoteRequest();

  void setUpdateQuoteRequest(QuoteRequest updateQuoteRequest);

  @JsonProperty("quotes")
  QuoteQueryResult getQuotes();

  void setQuotes(QuoteQueryResult quotes);
}
