package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public class CartFragmentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  {
    getFields().put("__typename", null);
  }

  public CartFragmentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Cart"));
  }

  public CartFragmentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public CustomerProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public LineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public DiscountOnTotalPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> discountOnTotalPrice(
      ) {
     DiscountOnTotalPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountOnTotalPriceProjection<>(this, getRoot());
     getFields().put("discountOnTotalPrice", projection);
     return projection;
  }

  public AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public InventoryModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> taxCalculationMode(
      ) {
     TaxCalculationModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public CustomerGroupProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public ReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public ShippingInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public DiscountCodeInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> discountCodes() {
     DiscountCodeInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountCodeInfoProjection<>(this, getRoot());
     getFields().put("discountCodes", projection);
     return projection;
  }

  public DirectDiscountProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public CartDiscountProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> refusedGifts() {
     CartDiscountProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartDiscountProjection<>(this, getRoot());
     getFields().put("refusedGifts", projection);
     return projection;
  }

  public ReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> refusedGiftsRefs() {
     ReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("refusedGiftsRefs", projection);
     return projection;
  }

  public PaymentInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public ShippingRateInputProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shippingRateInput(
      ) {
     ShippingRateInputProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public CartOriginProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> origin() {
     CartOriginProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartOriginProjection<>(this, getRoot());
     getFields().put("origin", projection);
     return projection;
  }

  public KeyReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public BusinessUnitProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public ShippingProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shipping() {
     ShippingProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingProjection<>(this, getRoot());
     getFields().put("shipping", projection);
     return projection;
  }

  public TaxedPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> taxedShippingPrice() {
     TaxedPriceProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedShippingPrice", projection);
     return projection;
  }

  public ShippingModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shippingMode() {
     ShippingModeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingModeProjection<>(this, getRoot());
     getFields().put("shippingMode", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> shippingCustomFields(
      ) {
     CustomFieldsTypeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("shippingCustomFields", projection);
     return projection;
  }

  public DiscountTypeCombinationProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> discountTypeCombination(
      ) {
     DiscountTypeCombinationProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountTypeCombinationProjection<>(this, getRoot());
     getFields().put("discountTypeCombination", projection);
     return projection;
  }

  public CartStateProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> cartState() {
     CartStateProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartStateProjection<>(this, getRoot());
     getFields().put("cartState", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<CartFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public CartFragmentProjection<PARENT, ROOT> customerId() {
    getFields().put("customerId", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> customerEmail() {
    getFields().put("customerEmail", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> anonymousId() {
    getFields().put("anonymousId", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> shippingKey() {
    getFields().put("shippingKey", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> locale() {
    getFields().put("locale", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> deleteDaysAfterLastModification() {
    getFields().put("deleteDaysAfterLastModification", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> totalLineItemQuantity() {
    getFields().put("totalLineItemQuantity", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public CartFragmentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("... on Cart {");
    getFields().forEach((k, v) -> {
        builder.append(" ").append(k);
        if(v != null) {
            builder.append(" ").append(v.toString());
        }
    });
    builder.append("}");
     
    return builder.toString();
  }
}
