package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class CartProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public CartProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Cart"));
  }

  public CartProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public CustomerProjection<CartProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public LineItemProjection<CartProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<CartProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<CartProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<CartProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<CartProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public DiscountOnTotalPriceProjection<CartProjection<PARENT, ROOT>, ROOT> discountOnTotalPrice() {
     DiscountOnTotalPriceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new DiscountOnTotalPriceProjection<>(this, getRoot());
     getFields().put("discountOnTotalPrice", projection);
     return projection;
  }

  public AddressProjection<CartProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<CartProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public InventoryModeProjection<CartProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<CartProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<CartProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<CartProjection<PARENT, ROOT>, ROOT> taxCalculationMode() {
     TaxCalculationModeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public CustomerGroupProjection<CartProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public ReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public ShippingInfoProjection<CartProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public DiscountCodeInfoProjection<CartProjection<PARENT, ROOT>, ROOT> discountCodes() {
     DiscountCodeInfoProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new DiscountCodeInfoProjection<>(this, getRoot());
     getFields().put("discountCodes", projection);
     return projection;
  }

  public DirectDiscountProjection<CartProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public CartDiscountProjection<CartProjection<PARENT, ROOT>, ROOT> refusedGifts() {
     CartDiscountProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CartDiscountProjection<>(this, getRoot());
     getFields().put("refusedGifts", projection);
     return projection;
  }

  public ReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> refusedGiftsRefs() {
     ReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("refusedGiftsRefs", projection);
     return projection;
  }

  public PaymentInfoProjection<CartProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public ShippingRateInputProjection<CartProjection<PARENT, ROOT>, ROOT> shippingRateInput() {
     ShippingRateInputProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public CartOriginProjection<CartProjection<PARENT, ROOT>, ROOT> origin() {
     CartOriginProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CartOriginProjection<>(this, getRoot());
     getFields().put("origin", projection);
     return projection;
  }

  public KeyReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<CartProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public AddressProjection<CartProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public BusinessUnitProjection<CartProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public ShippingProjection<CartProjection<PARENT, ROOT>, ROOT> shipping() {
     ShippingProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ShippingProjection<>(this, getRoot());
     getFields().put("shipping", projection);
     return projection;
  }

  public TaxedPriceProjection<CartProjection<PARENT, ROOT>, ROOT> taxedShippingPrice() {
     TaxedPriceProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedShippingPrice", projection);
     return projection;
  }

  public ShippingModeProjection<CartProjection<PARENT, ROOT>, ROOT> shippingMode() {
     ShippingModeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new ShippingModeProjection<>(this, getRoot());
     getFields().put("shippingMode", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<CartProjection<PARENT, ROOT>, ROOT> shippingCustomFields() {
     CustomFieldsTypeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("shippingCustomFields", projection);
     return projection;
  }

  public DiscountTypeCombinationProjection<CartProjection<PARENT, ROOT>, ROOT> discountTypeCombination(
      ) {
     DiscountTypeCombinationProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new DiscountTypeCombinationProjection<>(this, getRoot());
     getFields().put("discountTypeCombination", projection);
     return projection;
  }

  public CartStateProjection<CartProjection<PARENT, ROOT>, ROOT> cartState() {
     CartStateProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CartStateProjection<>(this, getRoot());
     getFields().put("cartState", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<CartProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<CartProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<CartProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<CartProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public CartProjection<PARENT, ROOT> customerId() {
    getFields().put("customerId", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> customerEmail() {
    getFields().put("customerEmail", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> anonymousId() {
    getFields().put("anonymousId", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> shippingKey() {
    getFields().put("shippingKey", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> locale() {
    getFields().put("locale", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> deleteDaysAfterLastModification() {
    getFields().put("deleteDaysAfterLastModification", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> totalLineItemQuantity() {
    getFields().put("totalLineItemQuantity", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public CartProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
