package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.AttributeGroupDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateAttributeGroupGraphQLQuery extends GraphQLQuery {
  public CreateAttributeGroupGraphQLQuery(AttributeGroupDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateAttributeGroupGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createAttributeGroup";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private AttributeGroupDraft draft;

    private String queryName;

    public CreateAttributeGroupGraphQLQuery build() {
      return new CreateAttributeGroupGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(AttributeGroupDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
