package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CategoryDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateCategoryGraphQLQuery extends GraphQLQuery {
  public CreateCategoryGraphQLQuery(CategoryDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateCategoryGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createCategory";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CategoryDraft draft;

    private String queryName;

    public CreateCategoryGraphQLQuery build() {
      return new CreateCategoryGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CategoryDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
