package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.DiscountCodeDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateDiscountCodeGraphQLQuery extends GraphQLQuery {
  public CreateDiscountCodeGraphQLQuery(DiscountCodeDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateDiscountCodeGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createDiscountCode";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private DiscountCodeDraft draft;

    private String queryName;

    public CreateDiscountCodeGraphQLQuery build() {
      return new CreateDiscountCodeGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(DiscountCodeDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
