package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ExtensionDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateExtensionGraphQLQuery extends GraphQLQuery {
  public CreateExtensionGraphQLQuery(ExtensionDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateExtensionGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createExtension";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ExtensionDraft draft;

    private String queryName;

    public CreateExtensionGraphQLQuery build() {
      return new CreateExtensionGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ExtensionDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
