package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.OrderMyCartCommand;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CreateMyOrderFromCartGraphQLQuery extends GraphQLQuery {
  public CreateMyOrderFromCartGraphQLQuery(OrderMyCartCommand draft, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CreateMyOrderFromCartGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createMyOrderFromCart";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private OrderMyCartCommand draft;

    private String storeKey;

    private String queryName;

    public CreateMyOrderFromCartGraphQLQuery build() {
      return new CreateMyOrderFromCartGraphQLQuery(draft, storeKey, queryName, fieldsSet);
               
    }

    public Builder draft(OrderMyCartCommand draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
