package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.MyPaymentDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CreateMyPaymentGraphQLQuery extends GraphQLQuery {
  public CreateMyPaymentGraphQLQuery(MyPaymentDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateMyPaymentGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createMyPayment";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private MyPaymentDraft draft;

    private String queryName;

    public CreateMyPaymentGraphQLQuery build() {
      return new CreateMyPaymentGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(MyPaymentDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
