package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ProductDiscountDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateProductDiscountGraphQLQuery extends GraphQLQuery {
  public CreateProductDiscountGraphQLQuery(ProductDiscountDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateProductDiscountGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createProductDiscount";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ProductDiscountDraft draft;

    private String queryName;

    public CreateProductDiscountGraphQLQuery build() {
      return new CreateProductDiscountGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ProductDiscountDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
