package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ProductDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateProductGraphQLQuery extends GraphQLQuery {
  public CreateProductGraphQLQuery(ProductDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateProductGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createProduct";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ProductDraft draft;

    private String queryName;

    public CreateProductGraphQLQuery build() {
      return new CreateProductGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ProductDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
