package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ProductTailoringDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateProductTailoringGraphQLQuery extends GraphQLQuery {
  public CreateProductTailoringGraphQLQuery(String storeKey, ProductTailoringDraft draft,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateProductTailoringGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createProductTailoring";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String storeKey;

    private ProductTailoringDraft draft;

    private String queryName;

    public CreateProductTailoringGraphQLQuery build() {
      return new CreateProductTailoringGraphQLQuery(storeKey, draft, queryName, fieldsSet);
               
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder draft(ProductTailoringDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
