package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CreateStandalonePrice;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateStandalonePriceGraphQLQuery extends GraphQLQuery {
  public CreateStandalonePriceGraphQLQuery(CreateStandalonePrice draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateStandalonePriceGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createStandalonePrice";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CreateStandalonePrice draft;

    private String queryName;

    public CreateStandalonePriceGraphQLQuery build() {
      return new CreateStandalonePriceGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CreateStandalonePrice draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
