package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CreateStore;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateStoreGraphQLQuery extends GraphQLQuery {
  public CreateStoreGraphQLQuery(CreateStore draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateStoreGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createStore";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CreateStore draft;

    private String queryName;

    public CreateStoreGraphQLQuery build() {
      return new CreateStoreGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CreateStore draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
