package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.TypeDefinitionDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateTypeDefinitionGraphQLQuery extends GraphQLQuery {
  public CreateTypeDefinitionGraphQLQuery(TypeDefinitionDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateTypeDefinitionGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createTypeDefinition";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private TypeDefinitionDraft draft;

    private String queryName;

    public CreateTypeDefinitionGraphQLQuery build() {
      return new CreateTypeDefinitionGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(TypeDefinitionDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
