package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CreateZone;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateZoneGraphQLQuery extends GraphQLQuery {
  public CreateZoneGraphQLQuery(CreateZone draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateZoneGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createZone";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CreateZone draft;

    private String queryName;

    public CreateZoneGraphQLQuery build() {
      return new CreateZoneGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CreateZone draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
