package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CustomerActiveCartGraphQLQuery extends GraphQLQuery {
  public CustomerActiveCartGraphQLQuery(String customerId, String queryName,
      Set<String> fieldsSet) {
    super("query", queryName);
    if (customerId != null || fieldsSet.contains("customerId")) {
        getInput().put("customerId", customerId);
    }
  }

  public CustomerActiveCartGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "customerActiveCart";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String customerId;

    private String queryName;

    public CustomerActiveCartGraphQLQuery build() {
      return new CustomerActiveCartGraphQLQuery(customerId, queryName, fieldsSet);
               
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      this.fieldsSet.add("customerId");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
