package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CustomerChangeMyPasswordGraphQLQuery extends GraphQLQuery {
  public CustomerChangeMyPasswordGraphQLQuery(Long version, String currentPassword,
      String newPassword, String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (currentPassword != null || fieldsSet.contains("currentPassword")) {
        getInput().put("currentPassword", currentPassword);
    }if (newPassword != null || fieldsSet.contains("newPassword")) {
        getInput().put("newPassword", newPassword);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerChangeMyPasswordGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerChangeMyPassword";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private String currentPassword;

    private String newPassword;

    private String storeKey;

    private String queryName;

    public CustomerChangeMyPasswordGraphQLQuery build() {
      return new CustomerChangeMyPasswordGraphQLQuery(version, currentPassword, newPassword, storeKey, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder currentPassword(String currentPassword) {
      this.currentPassword = currentPassword;
      this.fieldsSet.add("currentPassword");
      return this;
    }

    public Builder newPassword(String newPassword) {
      this.newPassword = newPassword;
      this.fieldsSet.add("newPassword");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
