package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CustomerChangePasswordGraphQLQuery extends GraphQLQuery {
  public CustomerChangePasswordGraphQLQuery(String id, Long version, String currentPassword,
      String newPassword, String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (currentPassword != null || fieldsSet.contains("currentPassword")) {
        getInput().put("currentPassword", currentPassword);
    }if (newPassword != null || fieldsSet.contains("newPassword")) {
        getInput().put("newPassword", newPassword);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerChangePasswordGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerChangePassword";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String id;

    private Long version;

    private String currentPassword;

    private String newPassword;

    private String storeKey;

    private String queryName;

    public CustomerChangePasswordGraphQLQuery build() {
      return new CustomerChangePasswordGraphQLQuery(id, version, currentPassword, newPassword, storeKey, queryName, fieldsSet);
               
    }

    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder currentPassword(String currentPassword) {
      this.currentPassword = currentPassword;
      this.fieldsSet.add("currentPassword");
      return this;
    }

    public Builder newPassword(String newPassword) {
      this.newPassword = newPassword;
      this.fieldsSet.add("newPassword");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
