package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * Verifies customer's email using a token.
 */
public class CustomerConfirmEmailGraphQLQuery extends GraphQLQuery {
  public CustomerConfirmEmailGraphQLQuery(Long version, String tokenValue, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (tokenValue != null || fieldsSet.contains("tokenValue")) {
        getInput().put("tokenValue", tokenValue);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerConfirmEmailGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerConfirmEmail";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private String tokenValue;

    private String storeKey;

    private String queryName;

    public CustomerConfirmEmailGraphQLQuery build() {
      return new CustomerConfirmEmailGraphQLQuery(version, tokenValue, storeKey, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder tokenValue(String tokenValue) {
      this.tokenValue = tokenValue;
      this.fieldsSet.add("tokenValue");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
