package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CustomerConfirmMyEmailGraphQLQuery extends GraphQLQuery {
  public CustomerConfirmMyEmailGraphQLQuery(String tokenValue, String storeKey, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (tokenValue != null || fieldsSet.contains("tokenValue")) {
        getInput().put("tokenValue", tokenValue);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerConfirmMyEmailGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerConfirmMyEmail";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String tokenValue;

    private String storeKey;

    private String queryName;

    public CustomerConfirmMyEmailGraphQLQuery build() {
      return new CustomerConfirmMyEmailGraphQLQuery(tokenValue, storeKey, queryName, fieldsSet);
               
    }

    public Builder tokenValue(String tokenValue) {
      this.tokenValue = tokenValue;
      this.fieldsSet.add("tokenValue");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
