package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CustomerCreateEmailVerificationTokenGraphQLQuery extends GraphQLQuery {
  public CustomerCreateEmailVerificationTokenGraphQLQuery(String id, Long version,
      Integer ttlMinutes, String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (ttlMinutes != null || fieldsSet.contains("ttlMinutes")) {
        getInput().put("ttlMinutes", ttlMinutes);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerCreateEmailVerificationTokenGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerCreateEmailVerificationToken";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String id;

    private Long version;

    private Integer ttlMinutes;

    private String storeKey;

    private String queryName;

    public CustomerCreateEmailVerificationTokenGraphQLQuery build() {
      return new CustomerCreateEmailVerificationTokenGraphQLQuery(id, version, ttlMinutes, storeKey, queryName, fieldsSet);
               
    }

    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    /**
     * The validity of the created token in minutes.
     */
    public Builder ttlMinutes(Integer ttlMinutes) {
      this.ttlMinutes = ttlMinutes;
      this.fieldsSet.add("ttlMinutes");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
