package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * The token value is used to reset the password of the customer with the given email. The token is valid only for 10 minutes.
 */
public class CustomerCreatePasswordResetTokenGraphQLQuery extends GraphQLQuery {
  public CustomerCreatePasswordResetTokenGraphQLQuery(String email, Integer ttlMinutes,
      String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (email != null || fieldsSet.contains("email")) {
        getInput().put("email", email);
    }if (ttlMinutes != null || fieldsSet.contains("ttlMinutes")) {
        getInput().put("ttlMinutes", ttlMinutes);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerCreatePasswordResetTokenGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerCreatePasswordResetToken";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String email;

    private Integer ttlMinutes;

    private String storeKey;

    private String queryName;

    public CustomerCreatePasswordResetTokenGraphQLQuery build() {
      return new CustomerCreatePasswordResetTokenGraphQLQuery(email, ttlMinutes, storeKey, queryName, fieldsSet);
               
    }

    public Builder email(String email) {
      this.email = email;
      this.fieldsSet.add("email");
      return this;
    }

    /**
     * The validity of the created token in minutes.
     */
    public Builder ttlMinutes(Integer ttlMinutes) {
      this.ttlMinutes = ttlMinutes;
      this.fieldsSet.add("ttlMinutes");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
