package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CustomerResetMyPasswordGraphQLQuery extends GraphQLQuery {
  public CustomerResetMyPasswordGraphQLQuery(String tokenValue, String newPassword, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (tokenValue != null || fieldsSet.contains("tokenValue")) {
        getInput().put("tokenValue", tokenValue);
    }if (newPassword != null || fieldsSet.contains("newPassword")) {
        getInput().put("newPassword", newPassword);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerResetMyPasswordGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerResetMyPassword";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String tokenValue;

    private String newPassword;

    private String storeKey;

    private String queryName;

    public CustomerResetMyPasswordGraphQLQuery build() {
      return new CustomerResetMyPasswordGraphQLQuery(tokenValue, newPassword, storeKey, queryName, fieldsSet);
               
    }

    public Builder tokenValue(String tokenValue) {
      this.tokenValue = tokenValue;
      this.fieldsSet.add("tokenValue");
      return this;
    }

    public Builder newPassword(String newPassword) {
      this.newPassword = newPassword;
      this.fieldsSet.add("newPassword");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
