package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * The following workflow can be used to reset the customer’s password:
 *
 * 1. Create a password reset token and send it embedded in a link to the customer.
 * 2. When the customer clicks on the link, you may optionally retrieve customer by password token.
 * 3. When the customer entered new password, use reset customer’s password to reset the password.
 */
public class CustomerResetPasswordGraphQLQuery extends GraphQLQuery {
  public CustomerResetPasswordGraphQLQuery(Long version, String tokenValue, String newPassword,
      String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (tokenValue != null || fieldsSet.contains("tokenValue")) {
        getInput().put("tokenValue", tokenValue);
    }if (newPassword != null || fieldsSet.contains("newPassword")) {
        getInput().put("newPassword", newPassword);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerResetPasswordGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerResetPassword";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private String tokenValue;

    private String newPassword;

    private String storeKey;

    private String queryName;

    public CustomerResetPasswordGraphQLQuery build() {
      return new CustomerResetPasswordGraphQLQuery(version, tokenValue, newPassword, storeKey, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder tokenValue(String tokenValue) {
      this.tokenValue = tokenValue;
      this.fieldsSet.add("tokenValue");
      return this;
    }

    public Builder newPassword(String newPassword) {
      this.newPassword = newPassword;
      this.fieldsSet.add("newPassword");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
