package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CustomerSignMeUpDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta If used with an access token for Anonymous Sessions, all orders and carts belonging to the anonymousId will be assigned to the newly created customer.
 */
public class CustomerSignMeUpGraphQLQuery extends GraphQLQuery {
  public CustomerSignMeUpGraphQLQuery(CustomerSignMeUpDraft draft, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerSignMeUpGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerSignMeUp";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CustomerSignMeUpDraft draft;

    private String storeKey;

    private String queryName;

    public CustomerSignMeUpGraphQLQuery build() {
      return new CustomerSignMeUpGraphQLQuery(draft, storeKey, queryName, fieldsSet);
               
    }

    public Builder draft(CustomerSignMeUpDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
