package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class DeleteMyCustomerGraphQLQuery extends GraphQLQuery {
  public DeleteMyCustomerGraphQLQuery(Long version, Boolean personalDataErasure, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (personalDataErasure != null || fieldsSet.contains("personalDataErasure")) {
        getInput().put("personalDataErasure", personalDataErasure);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public DeleteMyCustomerGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "deleteMyCustomer";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private Boolean personalDataErasure;

    private String storeKey;

    private String queryName;

    public DeleteMyCustomerGraphQLQuery build() {
      return new DeleteMyCustomerGraphQLQuery(version, personalDataErasure, storeKey, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder personalDataErasure(Boolean personalDataErasure) {
      this.personalDataErasure = personalDataErasure;
      this.fieldsSet.add("personalDataErasure");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
