package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DeleteOrderGraphQLQuery extends GraphQLQuery {
  public DeleteOrderGraphQLQuery(Long version, Boolean personalDataErasure, String storeKey,
      String id, String orderNumber, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (personalDataErasure != null || fieldsSet.contains("personalDataErasure")) {
        getInput().put("personalDataErasure", personalDataErasure);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (orderNumber != null || fieldsSet.contains("orderNumber")) {
        getInput().put("orderNumber", orderNumber);
    }
  }

  public DeleteOrderGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "deleteOrder";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private Boolean personalDataErasure;

    private String storeKey;

    private String id;

    private String orderNumber;

    private String queryName;

    public DeleteOrderGraphQLQuery build() {
      return new DeleteOrderGraphQLQuery(version, personalDataErasure, storeKey, id, orderNumber, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder personalDataErasure(Boolean personalDataErasure) {
      this.personalDataErasure = personalDataErasure;
      this.fieldsSet.add("personalDataErasure");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      this.fieldsSet.add("orderNumber");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
