package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.AsAssociateArgument;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DeleteShoppingListGraphQLQuery extends GraphQLQuery {
  public DeleteShoppingListGraphQLQuery(Long version, Boolean personalDataErasure, String storeKey,
      AsAssociateArgument asAssociate, String id, String key, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (personalDataErasure != null || fieldsSet.contains("personalDataErasure")) {
        getInput().put("personalDataErasure", personalDataErasure);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (asAssociate != null || fieldsSet.contains("asAssociate")) {
        getInput().put("asAssociate", asAssociate);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }
  }

  public DeleteShoppingListGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "deleteShoppingList";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private Boolean personalDataErasure;

    private String storeKey;

    private AsAssociateArgument asAssociate;

    private String id;

    private String key;

    private String queryName;

    public DeleteShoppingListGraphQLQuery build() {
      return new DeleteShoppingListGraphQLQuery(version, personalDataErasure, storeKey, asAssociate, id, key, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder personalDataErasure(Boolean personalDataErasure) {
      this.personalDataErasure = personalDataErasure;
      this.fieldsSet.add("personalDataErasure");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    /**
     * Create/modify entity as an associate in business-unit.
     */
    public Builder asAssociate(AsAssociateArgument asAssociate) {
      this.asAssociate = asAssociate;
      this.fieldsSet.add("asAssociate");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
