package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * This field gives access to the resources (such as carts) that are inside one of the given stores.
 */
public class InStoresGraphQLQuery extends GraphQLQuery {
  public InStoresGraphQLQuery(List<String> keys, String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (keys != null || fieldsSet.contains("keys")) {
        getInput().put("keys", keys);
    }
  }

  public InStoresGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "inStores";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private List<String> keys;

    private String queryName;

    public InStoresGraphQLQuery build() {
      return new InStoresGraphQLQuery(keys, queryName, fieldsSet);
               
    }

    public Builder keys(List<String> keys) {
      this.keys = keys;
      this.fieldsSet.add("keys");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
