package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class LimitsGraphQLQuery extends GraphQLQuery {
  public LimitsGraphQLQuery(String queryName) {
    super("query", queryName);
  }

  public LimitsGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "limits";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String queryName;

    public LimitsGraphQLQuery build() {
      return new LimitsGraphQLQuery(queryName);                                     
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
