package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class LineItemProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public LineItemProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("LineItem"));
  }

  public LineItemProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public LocalizedStringProjection<LineItemProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<LineItemProjection<PARENT, ROOT>, ROOT> productSlugAllLocales() {
     LocalizedStringProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("productSlugAllLocales", projection);
     return projection;
  }

  public ProductTypeDefinitionProjection<LineItemProjection<PARENT, ROOT>, ROOT> productType() {
     ProductTypeDefinitionProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ProductTypeDefinitionProjection<>(this, getRoot());
     getFields().put("productType", projection);
     return projection;
  }

  public ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> productTypeRef() {
     ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("productTypeRef", projection);
     return projection;
  }

  public ProductVariantProjection<LineItemProjection<PARENT, ROOT>, ROOT> variant() {
     ProductVariantProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());
     getFields().put("variant", projection);
     return projection;
  }

  public ProductPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> price() {
     ProductPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceProjection<>(this, getRoot());
     getFields().put("price", projection);
     return projection;
  }

  public TaxedItemPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedItemPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new TaxedItemPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public MoneyProjection<LineItemProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public ItemStateProjection<LineItemProjection<PARENT, ROOT>, ROOT> state() {
     ItemStateProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ItemStateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public TaxRateProjection<LineItemProjection<PARENT, ROOT>, ROOT> taxRate() {
     TaxRateProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new TaxRateProjection<>(this, getRoot());
     getFields().put("taxRate", projection);
     return projection;
  }

  public ChannelProjection<LineItemProjection<PARENT, ROOT>, ROOT> supplyChannel() {
     ChannelProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ChannelProjection<>(this, getRoot());
     getFields().put("supplyChannel", projection);
     return projection;
  }

  public ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> supplyChannelRef() {
     ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("supplyChannelRef", projection);
     return projection;
  }

  public ChannelProjection<LineItemProjection<PARENT, ROOT>, ROOT> distributionChannel() {
     ChannelProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ChannelProjection<>(this, getRoot());
     getFields().put("distributionChannel", projection);
     return projection;
  }

  public ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> distributionChannelRef() {
     ReferenceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("distributionChannelRef", projection);
     return projection;
  }

  public DiscountedLineItemPriceForQuantityProjection<LineItemProjection<PARENT, ROOT>, ROOT> discountedPricePerQuantity(
      ) {
     DiscountedLineItemPriceForQuantityProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new DiscountedLineItemPriceForQuantityProjection<>(this, getRoot());
     getFields().put("discountedPricePerQuantity", projection);
     return projection;
  }

  public LineItemModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> lineItemMode() {
     LineItemModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new LineItemModeProjection<>(this, getRoot());
     getFields().put("lineItemMode", projection);
     return projection;
  }

  public LineItemPriceModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> priceMode() {
     LineItemPriceModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new LineItemPriceModeProjection<>(this, getRoot());
     getFields().put("priceMode", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<LineItemProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InventoryModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public ItemShippingDetailsProjection<LineItemProjection<PARENT, ROOT>, ROOT> shippingDetails() {
     ItemShippingDetailsProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new ItemShippingDetailsProjection<>(this, getRoot());
     getFields().put("shippingDetails", projection);
     return projection;
  }

  public MethodTaxRateProjection<LineItemProjection<PARENT, ROOT>, ROOT> perMethodTaxRate() {
     MethodTaxRateProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new MethodTaxRateProjection<>(this, getRoot());
     getFields().put("perMethodTaxRate", projection);
     return projection;
  }

  public MethodTaxedPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> taxedPricePortions() {
     MethodTaxedPriceProjection<LineItemProjection<PARENT, ROOT>, ROOT> projection = new MethodTaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPricePortions", projection);
     return projection;
  }

  public LineItemProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> productId() {
    getFields().put("productId", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> productKey() {
    getFields().put("productKey", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public LineItemProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> productSlug() {
    getFields().put("productSlug", null);
    return this;
  }

  public LineItemProjection productSlug(String locale, List<String> acceptLanguage) {
    getFields().put("productSlug", null);
    getInputArguments().computeIfAbsent("productSlug", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("productSlug").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("productSlug").add(acceptLanguageArg);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> quantity() {
    getFields().put("quantity", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> addedAt() {
    getFields().put("addedAt", null);
    return this;
  }

  public LineItemProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
