package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * This field can only be used with an access token created with the password flow or with an anonymous session.
 *
 * It gives access to the data that is specific to the customer or the anonymous session linked to the access token.
 */
public class MeGraphQLQuery extends GraphQLQuery {
  public MeGraphQLQuery(String queryName) {
    super("query", queryName);
  }

  public MeGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "me";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String queryName;

    public MeGraphQLQuery build() {
      return new MeGraphQLQuery(queryName);                                     
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
