package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class OrderProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public OrderProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Order"));
  }

  public OrderProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public CustomerProjection<OrderProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public LineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<OrderProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public DiscountOnTotalPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> discountOnTotalPrice(
      ) {
     DiscountOnTotalPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new DiscountOnTotalPriceProjection<>(this, getRoot());
     getFields().put("discountOnTotalPrice", projection);
     return projection;
  }

  public AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public InventoryModeProjection<OrderProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<OrderProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<OrderProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<OrderProjection<PARENT, ROOT>, ROOT> taxCalculationMode() {
     TaxCalculationModeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public CustomerGroupProjection<OrderProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public ShippingInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public DiscountCodeInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> discountCodes() {
     DiscountCodeInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new DiscountCodeInfoProjection<>(this, getRoot());
     getFields().put("discountCodes", projection);
     return projection;
  }

  public DirectDiscountProjection<OrderProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public DiscountTypeCombinationProjection<OrderProjection<PARENT, ROOT>, ROOT> discountTypeCombination(
      ) {
     DiscountTypeCombinationProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new DiscountTypeCombinationProjection<>(this, getRoot());
     getFields().put("discountTypeCombination", projection);
     return projection;
  }

  public CartDiscountProjection<OrderProjection<PARENT, ROOT>, ROOT> refusedGifts() {
     CartDiscountProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CartDiscountProjection<>(this, getRoot());
     getFields().put("refusedGifts", projection);
     return projection;
  }

  public ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> refusedGiftsRefs() {
     ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("refusedGiftsRefs", projection);
     return projection;
  }

  public PaymentInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public ShippingRateInputProjection<OrderProjection<PARENT, ROOT>, ROOT> shippingRateInput() {
     ShippingRateInputProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public CartOriginProjection<OrderProjection<PARENT, ROOT>, ROOT> origin() {
     CartOriginProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CartOriginProjection<>(this, getRoot());
     getFields().put("origin", projection);
     return projection;
  }

  public KeyReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<OrderProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public BusinessUnitProjection<OrderProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public ShippingProjection<OrderProjection<PARENT, ROOT>, ROOT> shipping() {
     ShippingProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ShippingProjection<>(this, getRoot());
     getFields().put("shipping", projection);
     return projection;
  }

  public TaxedPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> taxedShippingPrice() {
     TaxedPriceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedShippingPrice", projection);
     return projection;
  }

  public ShippingModeProjection<OrderProjection<PARENT, ROOT>, ROOT> shippingMode() {
     ShippingModeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ShippingModeProjection<>(this, getRoot());
     getFields().put("shippingMode", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<OrderProjection<PARENT, ROOT>, ROOT> shippingCustomFields() {
     CustomFieldsTypeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("shippingCustomFields", projection);
     return projection;
  }

  public OrderStateProjection<OrderProjection<PARENT, ROOT>, ROOT> orderState() {
     OrderStateProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new OrderStateProjection<>(this, getRoot());
     getFields().put("orderState", projection);
     return projection;
  }

  public ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<OrderProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public ShipmentStateProjection<OrderProjection<PARENT, ROOT>, ROOT> shipmentState() {
     ShipmentStateProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ShipmentStateProjection<>(this, getRoot());
     getFields().put("shipmentState", projection);
     return projection;
  }

  public PaymentStateProjection<OrderProjection<PARENT, ROOT>, ROOT> paymentState() {
     PaymentStateProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new PaymentStateProjection<>(this, getRoot());
     getFields().put("paymentState", projection);
     return projection;
  }

  public SyncInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> syncInfo() {
     SyncInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new SyncInfoProjection<>(this, getRoot());
     getFields().put("syncInfo", projection);
     return projection;
  }

  public ReturnInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> returnInfo() {
     ReturnInfoProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReturnInfoProjection<>(this, getRoot());
     getFields().put("returnInfo", projection);
     return projection;
  }

  public ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> cartRef() {
     ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("cartRef", projection);
     return projection;
  }

  public CartProjection<OrderProjection<PARENT, ROOT>, ROOT> cart() {
     CartProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CartProjection<>(this, getRoot());
     getFields().put("cart", projection);
     return projection;
  }

  public ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> quoteRef() {
     ReferenceProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("quoteRef", projection);
     return projection;
  }

  public QuoteProjection<OrderProjection<PARENT, ROOT>, ROOT> quote() {
     QuoteProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new QuoteProjection<>(this, getRoot());
     getFields().put("quote", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<OrderProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<OrderProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<OrderProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<OrderProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public OrderProjection<PARENT, ROOT> customerId() {
    getFields().put("customerId", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> customerEmail() {
    getFields().put("customerEmail", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> anonymousId() {
    getFields().put("anonymousId", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> shippingKey() {
    getFields().put("shippingKey", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> locale() {
    getFields().put("locale", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> completedAt() {
    getFields().put("completedAt", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> orderNumber() {
    getFields().put("orderNumber", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> purchaseOrderNumber() {
    getFields().put("purchaseOrderNumber", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> lastMessageSequenceNumber() {
    getFields().put("lastMessageSequenceNumber", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public OrderProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
