package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.SearchKeywordArgument;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProductProjectionsSuggestGraphQLQuery extends GraphQLQuery {
  public ProductProjectionsSuggestGraphQLQuery(List<SearchKeywordArgument> searchKeywords,
      Boolean fuzzy, Integer limit, Boolean staged, String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (searchKeywords != null || fieldsSet.contains("searchKeywords")) {
        getInput().put("searchKeywords", searchKeywords);
    }if (fuzzy != null || fieldsSet.contains("fuzzy")) {
        getInput().put("fuzzy", fuzzy);
    }if (limit != null || fieldsSet.contains("limit")) {
        getInput().put("limit", limit);
    }if (staged != null || fieldsSet.contains("staged")) {
        getInput().put("staged", staged);
    }
  }

  public ProductProjectionsSuggestGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "productProjectionsSuggest";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private List<SearchKeywordArgument> searchKeywords;

    private Boolean fuzzy;

    private Integer limit;

    private Boolean staged;

    private String queryName;

    public ProductProjectionsSuggestGraphQLQuery build() {
      return new ProductProjectionsSuggestGraphQLQuery(searchKeywords, fuzzy, limit, staged, queryName, fieldsSet);
               
    }

    public Builder searchKeywords(List<SearchKeywordArgument> searchKeywords) {
      this.searchKeywords = searchKeywords;
      this.fieldsSet.add("searchKeywords");
      return this;
    }

    public Builder fuzzy(Boolean fuzzy) {
      this.fuzzy = fuzzy;
      this.fieldsSet.add("fuzzy");
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = limit;
      this.fieldsSet.add("limit");
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      this.fieldsSet.add("staged");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
