package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;

public class ProductVariantProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ProductVariantProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("ProductVariant"));
  }

  public ProductVariantProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> prices() {
     ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceProjection<>(this, getRoot());
     getFields().put("prices", projection);
     return projection;
  }

  public ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> price() {
     ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceProjection<>(this, getRoot());
     getFields().put("price", projection);
     return projection;
  }

  public ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> price(
      Currency currency, String country, String customerGroupId,
      List<String> customerGroupAssignmentIds, String channelId, OffsetDateTime date) {
    ProductPriceProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceProjection<>(this, getRoot());    
    getFields().put("price", projection);
    getInputArguments().computeIfAbsent("price", k -> new ArrayList<>());                      
    InputArgument currencyArg = new InputArgument("currency", currency);
    getInputArguments().get("price").add(currencyArg);
    InputArgument countryArg = new InputArgument("country", country);
    getInputArguments().get("price").add(countryArg);
    InputArgument customerGroupIdArg = new InputArgument("customerGroupId", customerGroupId);
    getInputArguments().get("price").add(customerGroupIdArg);
    InputArgument customerGroupAssignmentIdsArg = new InputArgument("customerGroupAssignmentIds", customerGroupAssignmentIds);
    getInputArguments().get("price").add(customerGroupAssignmentIdsArg);
    InputArgument channelIdArg = new InputArgument("channelId", channelId);
    getInputArguments().get("price").add(channelIdArg);
    InputArgument dateArg = new InputArgument("date", date);
    getInputArguments().get("price").add(dateArg);
    return projection;
  }

  public ImageProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> images() {
     ImageProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new ImageProjection<>(this, getRoot());
     getFields().put("images", projection);
     return projection;
  }

  public AssetProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> assets() {
     AssetProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new AssetProjection<>(this, getRoot());
     getFields().put("assets", projection);
     return projection;
  }

  public ProductVariantAvailabilityWithChannelsProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> availability(
      ) {
     ProductVariantAvailabilityWithChannelsProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantAvailabilityWithChannelsProjection<>(this, getRoot());
     getFields().put("availability", projection);
     return projection;
  }

  public RawProductAttributeProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> attributesRaw(
      ) {
     RawProductAttributeProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new RawProductAttributeProjection<>(this, getRoot());
     getFields().put("attributesRaw", projection);
     return projection;
  }

  public RawProductAttributeProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> attributesRaw(
      List<String> includeNames, List<String> excludeNames) {
    RawProductAttributeProjection<ProductVariantProjection<PARENT, ROOT>, ROOT> projection = new RawProductAttributeProjection<>(this, getRoot());    
    getFields().put("attributesRaw", projection);
    getInputArguments().computeIfAbsent("attributesRaw", k -> new ArrayList<>());                      
    InputArgument includeNamesArg = new InputArgument("includeNames", includeNames);
    getInputArguments().get("attributesRaw").add(includeNamesArg);
    InputArgument excludeNamesArg = new InputArgument("excludeNames", excludeNames);
    getInputArguments().get("attributesRaw").add(excludeNamesArg);
    return projection;
  }

  public ProductVariantProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ProductVariantProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ProductVariantProjection<PARENT, ROOT> sku() {
    getFields().put("sku", null);
    return this;
  }
}
