package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProductsGraphQLQuery extends GraphQLQuery {
  public ProductsGraphQLQuery(String where, List<String> sort, Integer limit, Integer offset,
      Boolean projectExpandedProducts, List<String> localeProjection, List<String> skus,
      String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (where != null || fieldsSet.contains("where")) {
        getInput().put("where", where);
    }if (sort != null || fieldsSet.contains("sort")) {
        getInput().put("sort", sort);
    }if (limit != null || fieldsSet.contains("limit")) {
        getInput().put("limit", limit);
    }if (offset != null || fieldsSet.contains("offset")) {
        getInput().put("offset", offset);
    }if (projectExpandedProducts != null || fieldsSet.contains("projectExpandedProducts")) {
        getInput().put("projectExpandedProducts", projectExpandedProducts);
    }if (localeProjection != null || fieldsSet.contains("localeProjection")) {
        getInput().put("localeProjection", localeProjection);
    }if (skus != null || fieldsSet.contains("skus")) {
        getInput().put("skus", skus);
    }
  }

  public ProductsGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "products";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String where;

    private List<String> sort;

    private Integer limit;

    private Integer offset;

    private Boolean projectExpandedProducts;

    private List<String> localeProjection;

    private List<String> skus;

    private String queryName;

    public ProductsGraphQLQuery build() {
      return new ProductsGraphQLQuery(where, sort, limit, offset, projectExpandedProducts, localeProjection, skus, queryName, fieldsSet);
               
    }

    public Builder where(String where) {
      this.where = where;
      this.fieldsSet.add("where");
      return this;
    }

    public Builder sort(List<String> sort) {
      this.sort = sort;
      this.fieldsSet.add("sort");
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = limit;
      this.fieldsSet.add("limit");
      return this;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      this.fieldsSet.add("offset");
      return this;
    }

    public Builder projectExpandedProducts(Boolean projectExpandedProducts) {
      this.projectExpandedProducts = projectExpandedProducts;
      this.fieldsSet.add("projectExpandedProducts");
      return this;
    }

    public Builder localeProjection(List<String> localeProjection) {
      this.localeProjection = localeProjection;
      this.fieldsSet.add("localeProjection");
      return this;
    }

    /**
     * Queries for products with specified SKUs
     */
    public Builder skus(List<String> skus) {
      this.skus = skus;
      this.fieldsSet.add("skus");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
