package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class QuoteProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public QuoteProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Quote"));
  }

  public QuoteProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> customerRef() {
     ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerRef", projection);
     return projection;
  }

  public CustomerProjection<QuoteProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public CustomerGroupProjection<QuoteProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public LineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<QuoteProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<QuoteProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public InventoryModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> taxCalculationMode() {
     TaxCalculationModeProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public ShippingInfoProjection<QuoteProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public PaymentInfoProjection<QuoteProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public DirectDiscountProjection<QuoteProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public ShippingRateInputProjection<QuoteProjection<PARENT, ROOT>, ROOT> shippingRateInput() {
     ShippingRateInputProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public KeyReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<QuoteProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public BusinessUnitProjection<QuoteProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public QuoteStateProjection<QuoteProjection<PARENT, ROOT>, ROOT> quoteState() {
     QuoteStateProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new QuoteStateProjection<>(this, getRoot());
     getFields().put("quoteState", projection);
     return projection;
  }

  public ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> stagedQuoteRef() {
     ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stagedQuoteRef", projection);
     return projection;
  }

  public StagedQuoteProjection<QuoteProjection<PARENT, ROOT>, ROOT> stagedQuote() {
     StagedQuoteProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new StagedQuoteProjection<>(this, getRoot());
     getFields().put("stagedQuote", projection);
     return projection;
  }

  public ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> quoteRequestRef() {
     ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("quoteRequestRef", projection);
     return projection;
  }

  public QuoteRequestProjection<QuoteProjection<PARENT, ROOT>, ROOT> quoteRequest() {
     QuoteRequestProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new QuoteRequestProjection<>(this, getRoot());
     getFields().put("quoteRequest", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<QuoteProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<QuoteProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public InitiatorProjection<QuoteProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<QuoteProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<QuoteProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public QuoteProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> validTo() {
    getFields().put("validTo", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> sellerComment() {
    getFields().put("sellerComment", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> buyerComment() {
    getFields().put("buyerComment", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> purchaseOrderNumber() {
    getFields().put("purchaseOrderNumber", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public QuoteProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
