package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.AsAssociateArgument;
import com.commercetools.graphql.api.types.ReferenceInput;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class ReplicateCartGraphQLQuery extends GraphQLQuery {
  public ReplicateCartGraphQLQuery(ReferenceInput reference, String key, String storeKey,
      AsAssociateArgument asAssociate, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (reference != null || fieldsSet.contains("reference")) {
        getInput().put("reference", reference);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (asAssociate != null || fieldsSet.contains("asAssociate")) {
        getInput().put("asAssociate", asAssociate);
    }
  }

  public ReplicateCartGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "replicateCart";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ReferenceInput reference;

    private String key;

    private String storeKey;

    private AsAssociateArgument asAssociate;

    private String queryName;

    public ReplicateCartGraphQLQuery build() {
      return new ReplicateCartGraphQLQuery(reference, key, storeKey, asAssociate, queryName, fieldsSet);
               
    }

    public Builder reference(ReferenceInput reference) {
      this.reference = reference;
      this.fieldsSet.add("reference");
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    /**
     * Create/modify entity as an associate in business-unit.
     */
    public Builder asAssociate(AsAssociateArgument asAssociate) {
      this.asAssociate = asAssociate;
      this.fieldsSet.add("asAssociate");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
