package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.SignUpInMyBusinessUnitDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta Signs up a new customer and associates it with the business unit.
 */
public class SignUpInMyBusinessUnitGraphQLQuery extends GraphQLQuery {
  public SignUpInMyBusinessUnitGraphQLQuery(SignUpInMyBusinessUnitDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public SignUpInMyBusinessUnitGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "signUpInMyBusinessUnit";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private SignUpInMyBusinessUnitDraft draft;

    private String queryName;

    public SignUpInMyBusinessUnitGraphQLQuery build() {
      return new SignUpInMyBusinessUnitGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(SignUpInMyBusinessUnitDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
