package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class StateFragmentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  {
    getFields().put("__typename", null);
  }

  public StateFragmentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("State"));
  }

  public StateFragmentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public StateTypeProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> type() {
     StateTypeProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new StateTypeProjection<>(this, getRoot());
     getFields().put("type", projection);
     return projection;
  }

  public StateRoleProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> roles() {
     StateRoleProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new StateRoleProjection<>(this, getRoot());
     getFields().put("roles", projection);
     return projection;
  }

  public LocalizedStringProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> descriptionAllLocales(
      ) {
     LocalizedStringProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public ReferenceProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> transitionsRef() {
     ReferenceProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("transitionsRef", projection);
     return projection;
  }

  public StateProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> transitions() {
     StateProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("transitions", projection);
     return projection;
  }

  public InitiatorProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<StateFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public StateFragmentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public StateFragmentProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public StateFragmentProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> builtIn() {
    getFields().put("builtIn", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> initial() {
    getFields().put("initial", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public StateFragmentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("... on State {");
    getFields().forEach((k, v) -> {
        builder.append(" ").append(k);
        if(v != null) {
            builder.append(" ").append(v.toString());
        }
    });
    builder.append("}");
     
    return builder.toString();
  }
}
