package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.MyPaymentUpdateAction;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateMyPaymentGraphQLQuery extends GraphQLQuery {
  public UpdateMyPaymentGraphQLQuery(String id, Long version, List<MyPaymentUpdateAction> actions,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (actions != null || fieldsSet.contains("actions")) {
        getInput().put("actions", actions);
    }
  }

  public UpdateMyPaymentGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "updateMyPayment";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String id;

    private Long version;

    private List<MyPaymentUpdateAction> actions;

    private String queryName;

    public UpdateMyPaymentGraphQLQuery build() {
      return new UpdateMyPaymentGraphQLQuery(id, version, actions, queryName, fieldsSet);
               
    }

    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder actions(List<MyPaymentUpdateAction> actions) {
      this.actions = actions;
      this.fieldsSet.add("actions");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
