package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AWSLambdaDestination implements com.commercetools.graphql.api.types.ExtensionDestination {
  private String arn;

  private String accessKey;

  private String accessSecret;

  private String type;

  public AWSLambdaDestination() {
  }

  public AWSLambdaDestination(String arn, String accessKey, String accessSecret, String type) {
    this.arn = arn;
    this.accessKey = accessKey;
    this.accessSecret = accessSecret;
    this.type = type;
  }

  public String getArn() {
    return arn;
  }

  public void setArn(String arn) {
    this.arn = arn;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getAccessSecret() {
    return accessSecret;
  }

  public void setAccessSecret(String accessSecret) {
    this.accessSecret = accessSecret;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AWSLambdaDestination{arn='" + arn + "', accessKey='" + accessKey + "', accessSecret='" + accessSecret + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AWSLambdaDestination that = (AWSLambdaDestination) o;
    return Objects.equals(arn, that.arn) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(accessSecret, that.accessSecret) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arn, accessKey, accessSecret, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String arn;

    private String accessKey;

    private String accessSecret;

    private String type;

    public AWSLambdaDestination build() {
      AWSLambdaDestination result = new AWSLambdaDestination();
      result.arn = this.arn;
      result.accessKey = this.accessKey;
      result.accessSecret = this.accessSecret;
      result.type = this.type;
      return result;
    }

    public Builder arn(String arn) {
      this.arn = arn;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder accessSecret(String accessSecret) {
      this.accessSecret = accessSecret;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
