package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AbsoluteCartDiscountValueInput {
  private List<MoneyInput> money;

  private DiscountApplicationMode applicationMode;

  public AbsoluteCartDiscountValueInput() {
  }

  public AbsoluteCartDiscountValueInput(List<MoneyInput> money,
      DiscountApplicationMode applicationMode) {
    this.money = money;
    this.applicationMode = applicationMode;
  }

  public List<MoneyInput> getMoney() {
    return money;
  }

  public void setMoney(List<MoneyInput> money) {
    this.money = money;
  }

  public DiscountApplicationMode getApplicationMode() {
    return applicationMode;
  }

  public void setApplicationMode(DiscountApplicationMode applicationMode) {
    this.applicationMode = applicationMode;
  }

  @Override
  public String toString() {
    return "AbsoluteCartDiscountValueInput{money='" + money + "', applicationMode='" + applicationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AbsoluteCartDiscountValueInput that = (AbsoluteCartDiscountValueInput) o;
    return Objects.equals(money, that.money) &&
        Objects.equals(applicationMode, that.applicationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(money, applicationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<MoneyInput> money;

    private DiscountApplicationMode applicationMode;

    public AbsoluteCartDiscountValueInput build() {
      AbsoluteCartDiscountValueInput result = new AbsoluteCartDiscountValueInput();
      result.money = this.money;
      result.applicationMode = this.applicationMode;
      return result;
    }

    public Builder money(List<MoneyInput> money) {
      this.money = money;
      return this;
    }

    public Builder applicationMode(DiscountApplicationMode applicationMode) {
      this.applicationMode = applicationMode;
      return this;
    }
  }
}
