package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AbsoluteDiscountValue implements com.commercetools.graphql.api.types.CartDiscountValue, com.commercetools.graphql.api.types.ProductDiscountValue {
  private List<Money> money;

  private String type;

  public AbsoluteDiscountValue() {
  }

  public AbsoluteDiscountValue(List<Money> money, String type) {
    this.money = money;
    this.type = type;
  }

  public List<Money> getMoney() {
    return money;
  }

  public void setMoney(List<Money> money) {
    this.money = money;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AbsoluteDiscountValue{money='" + money + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AbsoluteDiscountValue that = (AbsoluteDiscountValue) o;
    return Objects.equals(money, that.money) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(money, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Money> money;

    private String type;

    public AbsoluteDiscountValue build() {
      AbsoluteDiscountValue result = new AbsoluteDiscountValue();
      result.money = this.money;
      result.type = this.type;
      return result;
    }

    public Builder money(List<Money> money) {
      this.money = money;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
